/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.plugins.csv;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.PreviewUtil;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validators.TableValidator;
import com.tcs.efiling.plugins.Plugin;
import com.tcs.efiling.plugins.csv.CSVPluginOtherTables;
import com.tcs.efiling.plugins.csv.CSVTableValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.stage.FileChooser;
import javax.xml.xpath.XPathConstants;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSVPlugin
implements Plugin {
    public static final String ID = "IMPORT_CSV_PLUGIN";
    private static FileChooser fileChooser;
    private static Map<String, File> tempImportedFiles;
    private static Map<String, List<String[]>> tableValueMatrix;
    private static Map<String, List<String>> tablefields;
    private static long[] addition;
    private static long[] deduction;
    private static final String DEPR_FIELD = "form3CdDeprAllw.3cb18";
    private static final String ADDITION_FIELD = "form3CdDeprAllw.3cb18[0].addcsv";
    private static final String DEDUCTION_FIELD = "form3CdDeprAllw.3cb18[0].dedcsv";
    private static Node nextOfDepr;
    private static Node deprDummy;
    private static int rowAdded;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void init() {
    }

    @Override
    public Object invoke(String actionType, JSObject args) {
        if ("DEPR_ADD".equals(actionType) || "DEPR_DED".equals(actionType)) {
            this.importToTable(args, actionType);
            return true;
        }
        if ("DEPR_ADD_FILL_DATA".equals(actionType) || "DEPR_DED_FILL_DATA".equals(actionType)) {
            return this.fillToTable(args, actionType);
        }
        if ("GET_FIELDS".equals(actionType)) {
            return this.getFieldsFromFile(args);
        }
        if ("SET_FIELDS".equals(actionType)) {
            return this.setFieldsInMatrix(args);
        }
        if ("SAVE_CSV".equals(actionType)) {
            return this.saveFieldsInFile(args);
        }
        if ("MOD_PREVIEW".equals(actionType)) {
            return this.modifyPreview();
        }
        if ("CSV_TEMPLATE_ADD".equals(actionType) || "CSV_TEMPLATE_DED".equals(actionType) || "CSV_TEMPLATE_OTHERS".equals(actionType)) {
            this.openCSVSaveDialog(args, actionType);
            return true;
        }
        if ("VIEW_CSV".equals(actionType)) {
            return this.printCSVFile(args);
        }
        if ("DELETE_ROW".equals(actionType)) {
            return this.deleteCSVFile(args);
        }
        if ("DELETE_TEMP_FILES".equals(actionType)) {
            return this.deleteTempFiles(args);
        }
        return false;
    }

    private Object deleteCSVFile(JSObject args) {
        try {
            int index = (Integer)args.getSlot(2);
            tempImportedFiles.remove("pt18TableAdd" + index);
            tempImportedFiles.remove("pt18TableDed" + index);
        }
        catch (Exception e) {
            System.out.println("exex::" + e);
        }
        return true;
    }

    private Object deleteTempFiles(JSObject args) {
        try {
            tempImportedFiles.clear();
        }
        catch (Exception e) {
            System.out.println("exex::" + e);
        }
        return true;
    }

    private void openCSVSaveDialog(JSObject args, String actionType) {
        try {
            String tableId = (String)args.getSlot(0);
            InputStream file1 = null;
            String extension = ".csv";
            if ("CSV_TEMPLATE_ADD".equals(actionType)) {
                String string = MainController.getInstance().getItrName();
                String string2 = MainController.getInstance().getAsstYear();
                MainController.getInstance();
                file1 = FormConfigUtil.getAdditionsCSVFile(string, string2, MainController.getVersion());
            } else if ("CSV_TEMPLATE_DED".equals(actionType)) {
                String string = MainController.getInstance().getItrName();
                String string3 = MainController.getInstance().getAsstYear();
                MainController.getInstance();
                file1 = FormConfigUtil.getDeductionsCSVFile(string, string3, MainController.getVersion());
            } else if ("CSV_TEMPLATE_OTHERS".equals(actionType)) {
                String string = MainController.getInstance().getItrName();
                String string4 = MainController.getInstance().getAsstYear();
                MainController.getInstance();
                file1 = FormConfigUtil.getCSVTemplates(string, string4, MainController.getVersion(), tableId);
            }
            if (file1 != null) {
                BufferedReader fr = new BufferedReader(new InputStreamReader(file1));
                this.initFileChooser(extension);
                File file2 = fileChooser.showSaveDialog(null);
                if (file2 == null) {
                    return;
                }
                if (!file2.getAbsolutePath().endsWith(extension)) {
                    file2 = new File(file2.getAbsolutePath() + extension);
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(file2));
                String line = null;
                while ((line = fr.readLine()) != null) {
                    bw.write(line);
                }
                fr.close();
                bw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object modifyPreview() {
        Document doc = PreviewUtil.doc;
        Set<String> data = tempImportedFiles.keySet();
        NodeList tabs = doc.getElementsByTagName("TABLE");
        Node addTable = null;
        Node dedTable = null;
        int len = tabs.getLength();
        for (int i = len - 1; i > 0; --i) {
            Node id = tabs.item(i).getAttributes().getNamedItem("id");
            if (id == null) continue;
            if ("additions".equals(id.getTextContent())) {
                addTable = tabs.item(i);
            } else if ("deductions".equals(id.getTextContent())) {
                dedTable = tabs.item(i);
            }
            if (addTable != null && dedTable != null) break;
        }
        int addCount = 0;
        int dedCount = 0;
        try {
            for (String table : data) {
                int i;
                Element cell;
                Element row;
                ArrayList<String> values;
                String line;
                BufferedReader br;
                if (table.indexOf("pt18TableAdd") != -1) {
                    br = new BufferedReader(new FileReader(tempImportedFiles.get(table)));
                    while ((line = br.readLine()) != null) {
                        values = CSVPlugin.splitSimpleCSV(line);
                        row = doc.createElement("TR");
                        addTable.appendChild(row);
                        cell = doc.createElement("TD");
                        row.appendChild(cell);
                        cell.setTextContent(String.valueOf(++addCount));
                        for (i = 0; i < values.size(); ++i) {
                            Element addCell = doc.createElement("TD");
                            row.appendChild(addCell);
                            addCell.setTextContent((String)values.get(i));
                        }
                    }
                    br.close();
                    continue;
                }
                if (table.indexOf("pt18TableDed") == -1) continue;
                br = new BufferedReader(new FileReader(tempImportedFiles.get(table)));
                while ((line = br.readLine()) != null) {
                    values = CSVPlugin.splitSimpleCSV(line);
                    row = doc.createElement("TR");
                    dedTable.appendChild(row);
                    cell = doc.createElement("TD");
                    row.appendChild(cell);
                    cell.setTextContent(String.valueOf(++dedCount));
                    for (i = 0; i < values.size(); ++i) {
                        Element dedCell = doc.createElement("TD");
                        row.appendChild(dedCell);
                        dedCell.setTextContent((String)values.get(i));
                    }
                }
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object saveFieldsInFile(JSObject args) {
        try {
            tableValueMatrix.clear();
            Document doc = FormUtil.getImportXmlDoc();
            if (doc == null) {
                return null;
            }
            NodeList deprNodes = (NodeList)ValidationCacher.xpath.evaluate(ValidationCacher.XPATH_TO_FIELD.get(DEPR_FIELD), doc, XPathConstants.NODESET);
            int deprLen = deprNodes.getLength();
            if (deprLen == 0) {
                return null;
            }
            for (int i = 0; i < deprLen; ++i) {
                int j;
                int k;
                int l;
                int j2;
                String addxpath = ValidationCacher.XPATH_TO_FIELD.get(ADDITION_FIELD);
                addxpath = addxpath.substring(0, addxpath.indexOf("[") + 1) + (i + 1) + addxpath.substring(addxpath.indexOf("]"));
                String dedxpath = ValidationCacher.XPATH_TO_FIELD.get(DEDUCTION_FIELD);
                dedxpath = dedxpath.substring(0, dedxpath.indexOf("[") + 1) + (i + 1) + dedxpath.substring(dedxpath.indexOf("]"));
                NodeList addNodeList = (NodeList)ValidationCacher.xpath.evaluate(addxpath, doc, XPathConstants.NODESET);
                NodeList dedNodeList = (NodeList)ValidationCacher.xpath.evaluate(dedxpath, doc, XPathConstants.NODESET);
                int addLen = addNodeList.getLength();
                int dedLen = dedNodeList.getLength();
                ArrayList<String[]> valueMatrixAdd = new ArrayList<String[]>();
                ArrayList<String[]> valueMatrixAddTemp = new ArrayList<String[]>();
                tableValueMatrix.put("pt18TableAdd" + i, valueMatrixAdd);
                ArrayList<String[]> valueMatrixDed = new ArrayList<String[]>();
                ArrayList<String[]> valueMatrixDedTemp = new ArrayList<String[]>();
                tableValueMatrix.put("pt18TableDed" + i, valueMatrixDed);
                Node addNode = null;
                Node dedNode = null;
                long[] additionsSum = new long[4];
                long deducSum = 0L;
                long totalPurchaseAmount = 0L;
                long totalModvatAmount = 0L;
                long totExRateAmount = 0L;
                long totalSubGrantAmount = 0L;
                long totalDeducAmount = 0L;
                for (int a = 0; a < deprNodes.item(i).getChildNodes().getLength(); ++a) {
                    if (deprNodes.item(i).getChildNodes().item(a).getNodeType() == 3) continue;
                    if (CSVPluginOtherTables.removeNameSpacePrefix(deprNodes.item(i).getChildNodes().item(a).getNodeName(), "TotalPurchase")) {
                        totalPurchaseAmount = Long.parseLong(deprNodes.item(i).getChildNodes().item(a).getTextContent());
                        continue;
                    }
                    if (CSVPluginOtherTables.removeNameSpacePrefix(deprNodes.item(i).getChildNodes().item(a).getNodeName(), "TotalModvat")) {
                        totalModvatAmount = Long.parseLong(deprNodes.item(i).getChildNodes().item(a).getTextContent());
                        continue;
                    }
                    if (CSVPluginOtherTables.removeNameSpacePrefix(deprNodes.item(i).getChildNodes().item(a).getNodeName(), "TotalChangeExchangeRate")) {
                        totExRateAmount = Long.parseLong(deprNodes.item(i).getChildNodes().item(a).getTextContent());
                        continue;
                    }
                    if (CSVPluginOtherTables.removeNameSpacePrefix(deprNodes.item(i).getChildNodes().item(a).getNodeName(), "TotalSubsidyGrant")) {
                        totalSubGrantAmount = Long.parseLong(deprNodes.item(i).getChildNodes().item(a).getTextContent());
                        continue;
                    }
                    if (!CSVPluginOtherTables.removeNameSpacePrefix(deprNodes.item(i).getChildNodes().item(a).getNodeName(), "TotalDeduction")) continue;
                    totalDeducAmount = Long.parseLong(deprNodes.item(i).getChildNodes().item(a).getTextContent());
                }
                for (j2 = 0; j2 < addLen; ++j2) {
                    addNode = addNodeList.item(j2);
                    int len = addNode.getChildNodes().getLength();
                    String[] addMatrix = new String[7];
                    l = 0;
                    for (k = 0; k < len; ++k) {
                        if (addNode.getChildNodes().item(k).getNodeType() == 3) continue;
                        addMatrix[l++] = addNode.getChildNodes().item(k).getTextContent();
                        if (CSVPluginOtherTables.removeNameSpacePrefix(addNode.getChildNodes().item(k).getNodeName(), "PurchaseOrSaleValue")) {
                            additionsSum[0] = additionsSum[0] + Long.parseLong(addNode.getChildNodes().item(k).getTextContent());
                            continue;
                        }
                        if (CSVPluginOtherTables.removeNameSpacePrefix(addNode.getChildNodes().item(k).getNodeName(), "Modvat")) {
                            additionsSum[1] = additionsSum[1] + Long.parseLong(addNode.getChildNodes().item(k).getTextContent());
                            continue;
                        }
                        if (CSVPluginOtherTables.removeNameSpacePrefix(addNode.getChildNodes().item(k).getNodeName(), "ExchangeRateChange")) {
                            additionsSum[2] = additionsSum[2] + Long.parseLong(addNode.getChildNodes().item(k).getTextContent());
                            continue;
                        }
                        if (!CSVPluginOtherTables.removeNameSpacePrefix(addNode.getChildNodes().item(k).getNodeName(), "subsidyGrant")) continue;
                        additionsSum[3] = additionsSum[3] + Long.parseLong(addNode.getChildNodes().item(k).getTextContent());
                    }
                    valueMatrixAddTemp.add(addMatrix);
                }
                if (additionsSum[0] == totalPurchaseAmount && additionsSum[1] == totalModvatAmount && additionsSum[2] == totExRateAmount && additionsSum[3] == totalSubGrantAmount) {
                    for (String[] arr : valueMatrixAddTemp) {
                        valueMatrixAdd.add(arr);
                    }
                }
                for (j = 0; j < addLen; ++j) {
                    addNodeList.item(j).getParentNode().removeChild(addNodeList.item(j));
                }
                for (j = 0; j < dedLen; ++j) {
                    dedNode = dedNodeList.item(j);
                    int len = dedNode.getChildNodes().getLength();
                    String[] matrix = new String[2];
                    l = 0;
                    for (k = 0; k < len; ++k) {
                        if (dedNode.getChildNodes().item(k).getNodeType() == 3) continue;
                        matrix[l++] = dedNode.getChildNodes().item(k).getTextContent();
                        if (!CSVPluginOtherTables.removeNameSpacePrefix(dedNode.getChildNodes().item(k).getNodeName(), "PurchaseOrSaleValue")) continue;
                        deducSum += Long.parseLong(dedNode.getChildNodes().item(k).getTextContent());
                    }
                    valueMatrixDedTemp.add(matrix);
                }
                if (deducSum == totalDeducAmount) {
                    for (String[] arr : valueMatrixDedTemp) {
                        valueMatrixDed.add(arr);
                    }
                }
                for (j2 = 0; j2 < dedLen; ++j2) {
                    dedNodeList.item(j2).getParentNode().removeChild(dedNodeList.item(j2));
                }
            }
            Set<String> keys = tableValueMatrix.keySet();
            for (String tableId : keys) {
                List<String[]> valueMatrix = tableValueMatrix.get(tableId);
                if (valueMatrix == null) continue;
                File tmpFile = File.createTempFile("ITD", tableId);
                BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
                boolean first = true;
                for (String[] str : valueMatrix) {
                    String line = CSVPlugin.joinSimpleCSV(str);
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                }
                bw.close();
                tempImportedFiles.put(tableId, tmpFile);
            }
            tableValueMatrix.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object setFieldsInMatrix(JSObject args) {
        List<Object> valueMatrix;
        String tableId = (String)args.getSlot(0);
        String tablePrefix = (String)args.getSlot(1);
        String feildName = (String)args.getSlot(2);
        String value = (String)args.getSlot(3);
        String rowIndex = tablePrefix.substring(tablePrefix.indexOf("[") + 1, tablePrefix.indexOf("]"));
        if (tableValueMatrix.containsKey(tableId + rowIndex)) {
            valueMatrix = tableValueMatrix.get(tableId + rowIndex);
        } else {
            valueMatrix = new ArrayList();
            tableValueMatrix.put(tableId + rowIndex, valueMatrix);
            CSVTableValidator validator = new CSVTableValidator(tableId, tablePrefix);
            tablefields.put(tableId, validator.getFields());
        }
        int index = tablefields.get(tableId).indexOf(feildName.replaceAll(".*\\[\\d+\\].", ""));
        int row = Integer.parseInt(feildName.substring(feildName.lastIndexOf("[") + 1, feildName.lastIndexOf("]")));
        if (valueMatrix.size() < row + 1) {
            valueMatrix.add(new String[tablefields.get(tableId).size()]);
        }
        if (index != -1) {
            ((String[])valueMatrix.get((int)row))[index] = value;
        }
        return null;
    }

    private Object getFieldsFromFile(JSObject args) {
        String tableId = (String)args.getSlot(0);
        String tablePrefix = (String)args.getSlot(1);
        int row = (Integer)args.getSlot(2);
        int index = (Integer)args.getSlot(3);
        if ("reset".equals(tableId)) {
            rowAdded = 0;
            deprDummy = null;
            return null;
        }
        LinkedHashMap fields = new LinkedHashMap();
        File tmpFile = tempImportedFiles.get(tableId + row);
        tablePrefix = tablePrefix.replaceAll("\\[\\d+\\]", "[" + String.valueOf(index) + "]");
        BufferedReader br = null;
        try {
            String line;
            if (tmpFile != null) {
                br = new BufferedReader(new FileReader(tmpFile));
            }
            String xpath = ValidationCacher.getXPath((String)args.getSlot(1));
            NodeList nodeZero = (NodeList)ValidationCacher.xpath.evaluate(xpath, FormUtil.getXmlDoc(), XPathConstants.NODESET);
            Node depr = nodeZero.item(0).getParentNode();
            if (index == 0 && deprDummy == null) {
                nextOfDepr = depr.getNextSibling();
                deprDummy = depr.cloneNode(true);
            }
            if (index > 0) {
                if (index > rowAdded) {
                    Node tempDepr = deprDummy.cloneNode(true);
                    FormUtil.changeNodeAttr(tempDepr, "form3CdDeprAllw.3cb18[" + index + "].descBlockAssets");
                    depr.getParentNode().insertBefore(tempDepr, nextOfDepr);
                    ++rowAdded;
                }
                xpath = xpath.substring(0, xpath.indexOf("[") + 1) + (index + 1) + xpath.substring(xpath.indexOf("]"));
                nodeZero = (NodeList)ValidationCacher.xpath.evaluate(xpath, FormUtil.getXmlDoc(), XPathConstants.NODESET);
            }
            int lineNo = 0;
            Node next = nodeZero.item(0).getNextSibling();
            while (br != null && (line = br.readLine()) != null) {
                ArrayList<String> values = CSVPlugin.splitSimpleCSV(line);
                int i = 0;
                Node cloneNode = nodeZero.item(0);
                if (lineNo > 0) {
                    cloneNode = nodeZero.item(0).cloneNode(true);
                    FormUtil.changeNodeAttr(cloneNode, ADDITION_FIELD);
                    nodeZero.item(0).getParentNode().insertBefore(cloneNode, next);
                }
                for (int j = 0; j < cloneNode.getChildNodes().getLength(); ++j) {
                    String val;
                    if (cloneNode.getChildNodes().item(j).getNodeType() == 3) continue;
                    if ((val = (String)values.get(i++)) != null && val.length() != 0 && val.matches("^[0-9]{2}(/)[0-9]{2}(/)[0-9]{4}$")) {
                        val = val.substring(6) + "-" + val.substring(3, 5) + "-" + val.substring(0, 2);
                    }
                    cloneNode.getChildNodes().item(j).setTextContent(val);
                }
                ++lineNo;
            }
            if (br != null) {
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fields;
    }

    private void importToTable(JSObject args, String actionType) {
        int len = (Integer)args.getMember("length");
        String[] strArgs = new String[len];
        for (int i = 0; i < len; ++i) {
            strArgs[i] = (String)args.getSlot(i);
        }
        this.initFileChooser(".csv");
        File file = fileChooser.showOpenDialog(null);
        if (file == null) {
            return;
        }
        Map<String, String> hashMap = this.importFileForTable(strArgs[0], strArgs[1], strArgs[2], file, actionType);
        if (hashMap.get("error") == null) {
            String lineNo = hashMap.get("lineNo");
            if ("DEPR_ADD".equals(actionType)) {
                MainController.itrEngine.executeScript("setCSVpt18AddValues(" + CSVPlugin.toJavascriptArray(addition) + "," + strArgs[3] + "," + lineNo + ");");
            } else if ("DEPR_DED".equals(actionType)) {
                MainController.itrEngine.executeScript("setCSVpt18DedValues(" + CSVPlugin.toJavascriptArray(deduction) + "," + strArgs[3] + "," + lineNo + ");");
            }
        } else {
            MainController.itrEngine.executeScript("showErrorMessage(\"" + hashMap.get("error") + "\");");
        }
    }

    private boolean fillToTable(JSObject args, String actionType) {
        try {
            int len = (Integer)args.getMember("length");
            String[] strArgs = new String[len];
            JSObject jsdata = (JSObject)args.getSlot(0);
            ArrayList<String> data = new ArrayList<String>();
            for (int j = 0; j < (Integer)jsdata.getMember("length"); ++j) {
                data.add((String)jsdata.getSlot(j));
            }
            for (int i = 1; i < len; ++i) {
                strArgs[i - 1] = (String)args.getSlot(i);
            }
            Map<String, String> hashMap = this.importDataForTable(strArgs[0], strArgs[1], strArgs[2], data, actionType);
            if (hashMap.get("error") == null) {
                String lineNo = hashMap.get("lineNo");
                if ("DEPR_ADD_FILL_DATA".equals(actionType)) {
                    MainController.itrEngine.executeScript("setCSVpt18AddValues(" + CSVPlugin.toJavascriptArray(addition) + "," + strArgs[3] + "," + lineNo + ");");
                } else if ("DEPR_DED_FILL_DATA".equals(actionType)) {
                    MainController.itrEngine.executeScript("setCSVpt18DedValues(" + CSVPlugin.toJavascriptArray(deduction) + "," + strArgs[3] + "," + lineNo + ");");
                }
                return true;
            }
            MainController.itrEngine.executeScript("showErrorMessage(\"" + hashMap.get("error") + "\");");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Map<String, String> importFileForTable(String tableId, String tablePrefix, String index, File file, String actionType) {
        int lineNo = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File tmpFile = File.createTempFile("ITD", tableId);
            BufferedReader br = new BufferedReader(new FileReader(file));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
            String error = null;
            CSVTableValidator csvTableValidator = new CSVTableValidator(tableId, tablePrefix);
            TableValidator tableValidator = (TableValidator)ValidationCacher.VALIDATION_MAP.get(tablePrefix).get(0).getValidator();
            csvTableValidator.setMandatoryFieldNames(tableValidator.getMandatoryFieldNames());
            csvTableValidator.setNotMadateFields(tableValidator.getNotMadateFields());
            csvTableValidator.setTableMandatory(tableValidator.getTableMandatory());
            addition = new long[6];
            deduction = new long[2];
            boolean first = true;
            String line = br.readLine();
            if (line != null) {
                while ((line = br.readLine()) != null) {
                    ArrayList<String> values = CSVPlugin.splitSimpleCSV(line);
                    error = csvTableValidator.validate(values);
                    ++lineNo;
                    if (error != null) {
                        addition = new long[6];
                        deduction = new long[2];
                        error = "Error at line no. " + (lineNo + 1) + ": " + error;
                        break;
                    }
                    if (values.size() == 7 && !csvTableValidator.checkSumOfAmountsinRange(Long.valueOf((String)values.get(2)) + Long.valueOf((String)values.get(3)) + Long.valueOf((String)values.get(4)) + Long.valueOf((String)values.get(5)), Long.valueOf((String)values.get(6)))) {
                        error = "Error at line no. " + (lineNo + 1) + ": " + ValidationCacher.getError("form3CdDeprAllw.3cb18.totalPurchaseValue.incorrect");
                        break;
                    }
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                    if ("DEPR_ADD".equals(actionType)) {
                        this.sumupAdditions(values);
                        continue;
                    }
                    if (!"DEPR_DED".equals(actionType)) continue;
                    this.sumupDeductions(values);
                }
            }
            bw.close();
            br.close();
            map.put("lineNo", Integer.toString(lineNo));
            map.put("error", error);
            if (ValidationUtil.isStringEmpty(error)) {
                tempImportedFiles.put(tableId + index, tmpFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, String> importDataForTable(String tableId, String tablePrefix, String index, List<String> data, String actionType) {
        index = index.replaceAll("\"", "");
        int lineNo = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File tmpFile = File.createTempFile("ITD", tableId);
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
            String error = null;
            CSVTableValidator csvTableValidator = new CSVTableValidator(tableId, tablePrefix);
            TableValidator tableValidator = (TableValidator)ValidationCacher.VALIDATION_MAP.get(tablePrefix).get(0).getValidator();
            csvTableValidator.setMandatoryFieldNames(tableValidator.getMandatoryFieldNames());
            csvTableValidator.setNotMadateFields(tableValidator.getNotMadateFields());
            csvTableValidator.setTableMandatory(tableValidator.getTableMandatory());
            addition = new long[6];
            deduction = new long[2];
            boolean first = true;
            for (String line : data) {
                ArrayList<String> values = CSVPlugin.splitSimpleCSV(line);
                error = csvTableValidator.validate(values);
                ++lineNo;
                if (error != null) {
                    addition = new long[6];
                    deduction = new long[2];
                    error = "Error at line no. " + lineNo + ": " + error;
                    break;
                }
                if (!first) {
                    bw.write("\n");
                }
                first = false;
                bw.write(line);
                if ("DEPR_ADD_FILL_DATA".equals(actionType)) {
                    this.sumupAdditions(values);
                    continue;
                }
                if (!"DEPR_DED_FILL_DATA".equals(actionType)) continue;
                this.sumupDeductions(values);
            }
            bw.close();
            map.put("lineNo", Integer.toString(lineNo));
            map.put("error", error);
            if (ValidationUtil.isStringEmpty(error)) {
                tempImportedFiles.put(tableId + index, tmpFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void sumupDeductions(List<String> values) {
        deduction[0] = deduction[0] + Long.parseLong(values.get(1));
        deduction[1] = deduction[1] + Math.max(0L, Long.parseLong(values.get(1)));
    }

    private void sumupAdditions(List<String> values) {
        addition[0] = addition[0] + Long.parseLong(values.get(2));
        addition[1] = addition[1] + Long.parseLong(values.get(3));
        addition[2] = addition[2] + Long.parseLong(values.get(4));
        addition[3] = addition[3] + Long.parseLong(values.get(5));
        addition[4] = addition[4] + Long.parseLong(values.get(6));
        addition[5] = addition[5] + Math.max(0L, Long.parseLong(values.get(2)) + Long.parseLong(values.get(3)) + Long.parseLong(values.get(4)) + Long.parseLong(values.get(5)));
    }

    public static String toJavascriptArray(long[] sumValues) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < sumValues.length; ++i) {
            sb.append(sumValues[i]);
            if (i >= sumValues.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static ArrayList<String> splitSimpleCSV(String s) {
        s = s.replaceAll("\"", "&quot;");
        if ((s = s.replaceAll("'", "")).endsWith(",")) {
            s = s + "&empty";
        }
        ArrayList<String> words = new ArrayList<String>();
        boolean notInsideComma = true;
        int start = 0;
        for (int i = 0; i < s.length() - 1; ++i) {
            if (s.charAt(i) == ',' && notInsideComma) {
                String tempValue = s.substring(start, i).replaceAll("\"", "").replace("&quot;", "");
                if (tempValue.matches("[0-9]{2}-[0-9]{2}-[0-9]{4}")) {
                    tempValue = tempValue.replaceAll("-", "/");
                } else if (tempValue.matches("^[A-Za-z]{5}[0-9]{4}[A-Za-z]{1}$") || tempValue.matches("^[A-Za-z]{4}[0-9]{5}[A-Za-z]{1}$")) {
                    tempValue = tempValue.toUpperCase();
                }
                if (tempValue.equals("\"")) {
                    words.add("");
                } else {
                    words.add(tempValue);
                }
                start = i + 1;
                continue;
            }
            if (s.charAt(i) != '\"') continue;
            notInsideComma = !notInsideComma;
        }
        String tempVal = s.substring(start).replaceAll("\"", "").replace("&quot;", "").replace("&empty", "");
        if (tempVal.matches("[0-9]{2}-[0-9]{2}-[0-9]{4}")) {
            tempVal = tempVal.replaceAll("-", "/");
        } else if (tempVal.matches("^[A-Za-z]{5}[0-9]{4}[A-Za-z]{1}$") || tempVal.matches("^[A-Za-z]{4}[0-9]{5}[A-Za-z]{1}$")) {
            tempVal = tempVal.toUpperCase();
        }
        if (tempVal.equals("\"")) {
            words.add("");
        } else {
            words.add(tempVal);
        }
        return words;
    }

    public static String joinSimpleCSV(String[] values) {
        StringBuilder line = new StringBuilder();
        for (String str : values) {
            if (str != null) {
                if ((str = str.replaceAll("\"", "&quot;")).contains(",")) {
                    str = str.replaceAll("&quot;", "");
                }
                line.append(str);
            }
            line.append(",");
        }
        return line.substring(0, line.length() - 1);
    }

    public static String joinSimpleCSV(BigInteger[] values) {
        StringBuilder line = new StringBuilder();
        for (BigInteger val : values) {
            if (val != null) {
                line.append(val);
            }
            line.append(",");
        }
        return line.substring(0, line.length() - 1);
    }

    public void initFileChooser(String extension) {
        if (fileChooser == null) {
            fileChooser = new FileChooser();
            if (extension.equals(".csv")) {
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV File (.csv)", new String[]{"*.csv"}));
            } else if (extension.equals(".docx")) {
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("doc File (.docx)", new String[]{"*.docx"}));
            }
        }
    }

    public Object printCSVFile(JSObject args) {
        try {
            String tableType = (String)args.getSlot(0);
            String row = (String)args.getSlot(2);
            InputStream templateFile = CSVPlugin.getPrviewTemplate();
            Document newDoc = FormCacher.getDocument(templateFile);
            NodeList tabs = newDoc.getElementsByTagName("table");
            Node addTable = null;
            Node dedTable = null;
            Node table = null;
            int len = tabs.getLength();
            for (int i = 0; i < len; ++i) {
                Node id = tabs.item(i).getAttributes().getNamedItem("id");
                if (id == null) continue;
                if ("additions".equals(id.getTextContent())) {
                    addTable = tabs.item(i);
                } else if ("deductions".equals(id.getTextContent())) {
                    dedTable = tabs.item(i);
                }
                if (addTable != null && dedTable != null) break;
            }
            if ("pt18TableAdd".equals(tableType)) {
                table = addTable;
                dedTable.setTextContent("");
            } else {
                table = dedTable;
                addTable.setTextContent("");
            }
            if (tempImportedFiles.get(tableType + row) != null) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(tempImportedFiles.get(tableType + row)));
                int addCount = 0;
                while ((line = br.readLine()) != null) {
                    ArrayList<String> values = CSVPlugin.splitSimpleCSV(line);
                    Element rowEle = newDoc.createElement("TR");
                    table.appendChild(rowEle);
                    Element cell = newDoc.createElement("TD");
                    rowEle.appendChild(cell);
                    cell.setTextContent(String.valueOf(++addCount));
                    for (int i = 0; i < values.size(); ++i) {
                        Element addCell = newDoc.createElement("TD");
                        rowEle.appendChild(addCell);
                        addCell.setTextContent((String)values.get(i));
                    }
                }
                br.close();
                String string = MainController.getInstance().getItrName();
                String string2 = MainController.getInstance().getAsstYear();
                MainController.getInstance();
                File tempFile = FormConfigUtil.getHtmlTempFile(string, string2, MainController.getVersion());
                FormUtil.writeHtmlToFile(tempFile, newDoc);
                PreviewUtil.print(tempFile);
                MainController.getInstance().generateErrorDialog(FormConfigUtil.getConfigProperty("msg.itr.preview"), false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static InputStream getPrviewTemplate() {
        StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
        MainController.getInstance();
        String path = stringBuilder.append(MainController.getVersion()).append("/Addtions_Deductions_Preview.html").toString();
        return FormConfigUtil.getResourceStream(path);
    }

    static {
        tempImportedFiles = new HashMap<String, File>();
        tableValueMatrix = new HashMap<String, List<String[]>>();
        tablefields = new HashMap<String, List<String>>();
        addition = new long[6];
        deduction = new long[2];
        nextOfDepr = null;
        deprDummy = null;
        rowAdded = 0;
    }
}

