/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import java.math.BigDecimal;

public class BigDecimalValidator
extends ValidatorInteface {
    private static final BigDecimal MIN_AMOUNT = BigDecimal.ZERO;
    private static final BigDecimal MAX_AMOUNT = BigDecimal.valueOf(1.0E17);
    private String conAttributeName;
    private String conAttributeValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private Boolean mandatory;

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        BigDecimal fieldValue = null;
        if (val != null && val.trim().length() != 0) {
            try {
                fieldValue = new BigDecimal(val.trim());
            }
            catch (Exception e) {
                String temp = this.getErrorCode();
                this.setErrorCode("error.amount.invalid");
                this.addFieldError(name, validator);
                this.setErrorCode(temp);
            }
        } else if (fieldValue == null) {
            return;
        }
        String acctualConAttributeValue = validator.getFormValue(this.conAttributeName, name);
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigDecimal minValueTemp = MIN_AMOUNT;
        if (this.minValue != null) {
            minValueTemp = this.minValue;
        }
        BigDecimal maxValueTemp = MAX_AMOUNT;
        if (this.maxValue != null) {
            maxValueTemp = this.maxValue;
        }
        if (!ValidationUtil.isStringEmpty(acctualConAttributeValue) && acctualConAttributeValue.equals(this.conAttributeValue)) {
            if (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0) {
                this.addFieldError(name, validator);
            }
        } else if (ValidationUtil.isStringEmpty(this.conAttributeName) && fieldValue != null && (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0)) {
            this.addFieldError(name, validator);
        }
    }

    public String getConAttributeName() {
        return this.conAttributeName;
    }

    public void setConAttributeName(String conAttributeName) {
        this.conAttributeName = conAttributeName;
    }

    public String getConAttributeValue() {
        return this.conAttributeValue;
    }

    public void setConAttributeValue(String conAttributeValue) {
        this.conAttributeValue = conAttributeValue;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }
}

