/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.WebServiceUtilSingle;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public class SubmitFORMSuccessController
implements Initializable {
    static final Logger LOG = Logger.getLogger(SubmitFORMSuccessController.class);
    private Stage myDialogStage;
    private MainController mainController;
    @FXML
    WebView formView;
    WebEngine webEngine;
    File itrvFile;
    String msg;
    static String formName;
    static String transactionId;
    static String emailId;
    static String caEmailId;
    static String ackNo;
    static int loadHomePage;

    public void initialize(URL url, ResourceBundle rb) {
        LOG.info("initialize starts");
        try {
            this.webEngine = this.formView.getEngine();
            this.loadITRVPage();
        }
        catch (Exception e) {
            LOG.error("ERror:", e);
            this.mainController.generateErrorDialog(e.getMessage(), true);
        }
    }

    public void loadITRVPage() throws Exception {
        LOG.info("loadITRVPage stats with transaction id " + transactionId + " ,email " + emailId + ",caEmailId:" + caEmailId + "formName:" + formName);
        this.webEngine.load(FormConfigUtil.getFormSuccessPage());
        loadHomePage = 0;
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                if (t1.equals((Object)Worker.State.SUCCEEDED) && loadHomePage == 0) {
                    LOG.info("SUCCEEDED loading");
                    JSObject jsobj = (JSObject)SubmitFORMSuccessController.this.webEngine.executeScript("window");
                    jsobj.setMember("main", SubmitFORMSuccessController.this);
                    ++loadHomePage;
                    if (WebServiceUtilSingle.is15CA) {
                        SubmitFORMSuccessController.this.webEngine.executeScript("setValues('" + transactionId + "','" + formName + "','" + ackNo + "','" + emailId + "');");
                    } else {
                        if (formName.startsWith("F")) {
                            formName = formName.substring(4);
                        }
                        SubmitFORMSuccessController.this.webEngine.executeScript("enableSuccessMsg('" + transactionId + "','" + emailId + "','" + caEmailId + "','" + formName + "');");
                    }
                }
            }
        });
    }

    @FXML
    public void ok() {
        this.myDialogStage.hide();
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public void setItrvFile(File itrvFile) {
        this.itrvFile = itrvFile;
    }

    public WebView getFormView() {
        return this.formView;
    }

    public void setFormView(WebView formView) {
        this.formView = formView;
    }

    public static String getFormName() {
        return formName;
    }

    public static void setFormName(String formName) {
        SubmitFORMSuccessController.formName = formName;
    }

    public static String getTransactionId() {
        return transactionId;
    }

    public static void setTransactionId(String transactionId) {
        SubmitFORMSuccessController.transactionId = transactionId;
    }

    public static String getEmailId() {
        return emailId;
    }

    public static void setEmailId(String emailId) {
        SubmitFORMSuccessController.emailId = emailId;
    }

    public static int getLoadHomePage() {
        return loadHomePage;
    }

    public static void setLoadHomePage(int loadHomePage) {
        SubmitFORMSuccessController.loadHomePage = loadHomePage;
    }

    public static String getCaEmailId() {
        return caEmailId;
    }

    public static void setCaEmailId(String caEmailId) {
        SubmitFORMSuccessController.caEmailId = caEmailId;
    }

    public static String getAckNo() {
        return ackNo;
    }

    public static void setAckNo(String ackNo) {
        SubmitFORMSuccessController.ackNo = ackNo;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    static {
        loadHomePage = 0;
    }
}

