/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.GetCARequest;
import com.tcs.efiling.form.config.GetCAResponse;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.CommonUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.NewFormDialog;
import com.tcs.efiling.form.main.PopUpController;
import com.tcs.efiling.form.main.SubmitFORMDialogController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.text.Font;
import javafx.stage.StageStyle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class GetCAUtil
extends Task<Void> {
    static final Logger LOG = Logger.getLogger(GetCAUtil.class);
    static SOAPConnectionFactory soapConnectionFactory;
    static SOAPConnection soapConnection;
    static JAXBContext getCAContent;
    static String url;
    String faultString;
    public static SubmitFORMDialogController controller;
    static MainController mainController;
    static JAXBContext responseContext;
    public static GetCARequest getCARequest;
    static List<String> schemaError;

    public static void init() {
        try {
            if (soapConnectionFactory == null) {
                soapConnectionFactory = SOAPConnectionFactory.newInstance();
                soapConnection = soapConnectionFactory.createConnection();
                url = FormConfigUtil.getConfigProperty("webservice.url");
                getCAContent = JAXBContext.newInstance((Class[])new Class[]{GetCARequest.class});
                responseContext = JAXBContext.newInstance((Class[])new Class[]{GetCAResponse.class});
            }
        }
        catch (Exception e) {
            LOG.error("Exception in init", e);
        }
    }

    public static SOAPMessage sendSoapMessage(JAXBContext context, Object obj) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage request = messageFactory.createMessage();
        SOAPPart soapPart = request.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody soapBody = envelope.getBody();
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(obj, (Node)soapBody);
        LOG.info("request: " + request);
        CommonUtil.writeSoapToLog(LOG, request);
        LOG.info("url: " + url);
        SOAPMessage response = soapConnection.call(request, (Object)url);
        LOG.info("response: " + response);
        return response;
    }

    public void sendRequest() {
        LOG.info("sendRequest starts");
        final ArrayList<String> caUser = new ArrayList<String>();
        try {
            schemaError.clear();
            SOAPMessage response = GetCAUtil.sendSoapMessage(getCAContent, getCARequest);
            SOAPBody resBody = response.getSOAPPart().getEnvelope().getBody();
            CommonUtil.writeSoapToLog(LOG, response);
            SOAPFault soapFault = resBody.getFault();
            LOG.info("Soap fault: " + soapFault);
            if (soapFault != null) {
                String faultActor = soapFault.getFaultActor();
                this.faultString = soapFault.getFaultString();
                String faultCode = soapFault.getFaultCode();
                String error = "FaultActor: " + faultActor + "<br/>FaultCode: " + faultCode + "<br/>Fault: " + this.faultString;
                schemaError.add(error);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.setErrorText(GetCAUtil.this.faultString);
                    }
                });
            } else {
                Node caNode = resBody.getFirstChild();
                GetCAResponse getCAResponse = (GetCAResponse)responseContext.createUnmarshaller().unmarshal(caNode);
                for (int i = 0; i < getCAResponse.getCaUsers().size(); ++i) {
                    caUser.add(getCAResponse.getCaUsers().get(i).getUserId());
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            controller.getCaUserId().getItems().addAll((Collection)caUser);
                            NewFormDialog myDialog = new NewFormDialog(null, true, "IMPORTANT !!!", "PopUp.fxml");
                            PopUpController popUpStartController = (PopUpController)myDialog.getController();
                            popUpStartController.setMyDialogStage(myDialog);
                            popUpStartController.setJavascript("");
                            popUpStartController.decorate(StageStyle.DECORATED);
                            popUpStartController.getMsgText().setFont(new Font(14.0));
                            popUpStartController.showDialogMin(FormConfigUtil.getConfigProperty("form.get.ca.list.mesg"));
                        }
                        catch (Exception e) {
                            LOG.error("errori ", e);
                            mainController.generateErrorDialog(e.getMessage(), true);
                        }
                    }
                });
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    controller.getProgress().setProgress(1.0);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error in sendRequest: ", e);
            schemaError.add(e.getMessage());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    controller.setErrorText(e.getMessage());
                }
            });
        }
    }

    public GetCARequest getGetCARequest() {
        return getCARequest;
    }

    public void setGetCARequest(GetCARequest getCARequest) {
        GetCAUtil.getCARequest = getCARequest;
    }

    protected Void call() throws Exception {
        GetCAUtil.init();
        this.sendRequest();
        return null;
    }

    static {
        getCAContent = null;
        url = "";
        getCARequest = new GetCARequest();
        schemaError = new ArrayList<String>();
    }
}

