/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.CopyPasteController;
import com.tcs.efiling.form.main.MainController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.w3c.dom.Document;

public class CopyPasteUtil
extends Task<Void> {
    static final Logger LOG = Logger.getLogger(CopyPasteUtil.class);
    private String TABLE_NAME;
    private String heads;
    private String last;
    private int rowPosition;
    private int colPosition;
    private int totalRows;
    private int clipBoardRows;
    private int addRows = 0;
    private int addCsvRows = 0;
    private Document document;
    MainController mainController;
    CopyPasteController copyPasteController;
    private String clipboardData;
    int panIndex;
    private String buttonType;
    File importCsvFile;
    ArrayList<ArrayList<String>> tableCellValuesScript = new ArrayList();
    public static Map<Integer, Map<Integer, String>> IMPORT_CLIP_MAP = new LinkedHashMap<Integer, Map<Integer, String>>();
    private static Map<Integer, Map<Integer, String>> IMPORT_CSV_MAP = new LinkedHashMap<Integer, Map<Integer, String>>();

    public int getClipBoardRows() {
        return this.clipBoardRows;
    }

    public void setClipBoardRows(int clipBoardRows) {
        this.clipBoardRows = clipBoardRows;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public void setRowPosition(int rowPosition) {
        this.rowPosition = rowPosition;
    }

    public int getColPosition() {
        return this.colPosition;
    }

    public void setColPosition(int colPosition) {
        this.colPosition = colPosition;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public CopyPasteController getCopyPasteController() {
        return this.copyPasteController;
    }

    public void setCopyPasteController(CopyPasteController copyPasteController) {
        this.copyPasteController = copyPasteController;
    }

    public String getTABLE_NAME() {
        return this.TABLE_NAME;
    }

    public void setTABLE_NAME(String TABLE_NAME) {
        this.TABLE_NAME = TABLE_NAME;
    }

    public String getHeads() {
        return this.heads;
    }

    public void setHeads(String heads) {
        this.heads = heads;
    }

    public String getLast() {
        return this.last;
    }

    public void setLast(String last) {
        this.last = last;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public String getClipboardData() {
        return this.clipboardData;
    }

    public void setClipboardData(String clipboardData) {
        this.clipboardData = clipboardData;
    }

    public int getPanIndex() {
        return this.panIndex;
    }

    public void setPanIndex(int panIndex) {
        this.panIndex = panIndex;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    public File getImportCsvFile() {
        return this.importCsvFile;
    }

    public void setImportCsvFile(File importCsvFile) {
        this.importCsvFile = importCsvFile;
    }

    public ArrayList<ArrayList<String>> getTableCellValuesScript() {
        return this.tableCellValuesScript;
    }

    public void setTableCellValuesScript(ArrayList<ArrayList<String>> tableCellValuesScript) {
        this.tableCellValuesScript = tableCellValuesScript;
    }

    public static void removeClipBoardData() {
        IMPORT_CLIP_MAP.clear();
    }

    public void getClipBoardData(String data) {
        String[] trValues = data.toLowerCase().split("</tr>");
        for (int i = 0; i < trValues.length - 1; ++i) {
            String[] tdValues = trValues[i].toLowerCase().split("</td>");
            for (int j = 0; j < tdValues.length - 1; ++j) {
                Map<Object, Object> tdValue;
                String value = tdValues[j].substring(tdValues[j].lastIndexOf(">") + 1);
                if (j == this.panIndex) {
                    value = value.toUpperCase();
                }
                if (IMPORT_CLIP_MAP.containsKey(i)) {
                    tdValue = IMPORT_CLIP_MAP.get(i);
                    tdValue.put(j, value);
                    continue;
                }
                tdValue = new LinkedHashMap<Integer, String>();
                tdValue.put(j, value);
                IMPORT_CLIP_MAP.put(i, tdValue);
            }
        }
    }

    public void addCPColumn() {
        int emptyRows = this.totalRows - this.rowPosition;
        this.addRows = IMPORT_CLIP_MAP.size() - emptyRows;
    }

    public void addImportCsvColumn() {
        if (IMPORT_CSV_MAP.size() > 500) {
            this.addCsvRows = IMPORT_CSV_MAP.size() - 500;
        }
    }

    public void saveCSVdata(File file) {
        try {
            if (file != null) {
                BufferedReader br = null;
                String line = "";
                String cvsSplitBy = ",";
                long time1 = System.currentTimeMillis();
                br = new BufferedReader(new FileReader(file.getAbsolutePath()));
                int rows = 0;
                while ((line = br.readLine()) != null) {
                    String[] values = line.split(cvsSplitBy);
                    ++rows;
                    for (int j = 0; j < values.length; ++j) {
                        Map<Object, Object> tdValue;
                        String value = values[j];
                        if (IMPORT_CSV_MAP.containsKey(rows)) {
                            tdValue = IMPORT_CSV_MAP.get(rows);
                            tdValue.put(j, value);
                            continue;
                        }
                        tdValue = new LinkedHashMap<Integer, String>();
                        tdValue.put(j, value);
                        IMPORT_CSV_MAP.put(rows, tdValue);
                    }
                }
                long time2 = System.currentTimeMillis();
                LOG.info("Time taken in saveCSVdata(): " + (time2 - time1));
                LOG.info("IMPORT_CSV_MAP size ::" + IMPORT_CSV_MAP.size());
            }
        }
        catch (Exception e) {
            LOG.error("startImport error : ", e);
            this.mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("error.csv.import.invalid"), true);
        }
    }

    protected Void call() throws Exception {
        try {
            LOG.info("buttonType:: " + this.buttonType);
            if (this.buttonType == "copyPaste") {
                this.getClipBoardData(this.clipboardData);
                this.addCPColumn();
            } else if (this.buttonType == "importCsv") {
                this.saveCSVdata(this.importCsvFile);
                this.addImportCsvColumn();
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (CopyPasteUtil.this.buttonType == "copyPaste") {
                        if (CopyPasteUtil.this.addRows > 0) {
                            CopyPasteUtil.this.mainController.copyPasteController.engine.executeScript("addDummyRows('" + CopyPasteUtil.this.addRows + "')");
                        }
                        for (Integer i : IMPORT_CLIP_MAP.keySet()) {
                            Map<Integer, String> tdValueMap = IMPORT_CLIP_MAP.get(i);
                            int temp = 0;
                            for (Integer j : tdValueMap.keySet()) {
                                CopyPasteUtil.this.mainController.copyPasteController.engine.executeScript("setCellValue('" + (CopyPasteUtil.this.rowPosition + i) + "','" + (++temp + CopyPasteUtil.this.colPosition) + "','" + tdValueMap.get(j) + "')");
                            }
                        }
                    } else if (CopyPasteUtil.this.buttonType == "importCsv") {
                        LOG.info("IMPORT_CSV_MAP " + IMPORT_CSV_MAP.size() + "addCsvRows ::" + CopyPasteUtil.this.addCsvRows);
                        long time1 = System.currentTimeMillis();
                        if (CopyPasteUtil.this.addCsvRows > 0) {
                            CopyPasteUtil.this.mainController.copyPasteController.engine.executeScript("addDummyRows('" + CopyPasteUtil.this.addCsvRows + "')");
                        }
                        for (Integer i : IMPORT_CSV_MAP.keySet()) {
                            Map tdValueMap = (Map)IMPORT_CSV_MAP.get(i);
                            int temp = 0;
                            if (tdValueMap.get(2) != null) {
                                tdValueMap.put(2, ((String)tdValueMap.get(2)).toUpperCase());
                            }
                            for (Integer j : tdValueMap.keySet()) {
                                CopyPasteUtil.this.mainController.copyPasteController.engine.executeScript("setCellValue('" + i + "','" + (++temp + CopyPasteUtil.this.colPosition) + "','" + (String)tdValueMap.get(j) + "')");
                            }
                        }
                        long time2 = System.currentTimeMillis();
                        LOG.info("Time taken in importCsv run later(): " + (time2 - time1));
                        IMPORT_CSV_MAP.clear();
                    } else if (CopyPasteUtil.this.buttonType == "saveCPData") {
                        LOG.info("RunLater saveCPData starts tableCellValuesScript.size()" + CopyPasteUtil.this.tableCellValuesScript.size());
                        for (int i = 0; i < CopyPasteUtil.this.tableCellValuesScript.size(); ++i) {
                            ArrayList<String> scripts = CopyPasteUtil.this.tableCellValuesScript.get(i);
                            for (int j = 0; j < scripts.size(); ++j) {
                                MainController cfr_ignored_0 = CopyPasteUtil.this.mainController;
                                MainController.itrEngine.executeScript(scripts.get(j));
                            }
                        }
                        CopyPasteUtil.this.tableCellValuesScript.clear();
                        CopyPasteUtil.this.copyPasteController.hideDialog();
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.error("error in copyPasteUtil call", e);
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return null;
    }
}

