/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

public class Base64Utils {
    private static byte[] mBase64EncMap;
    private static byte[] mBase64DecMap;

    public static String base64Encode(byte[] strData) {
        int iSrcIndex;
        if (strData == null || strData.length == 0) {
            throw new IllegalArgumentException("Can not encode NULL or Empty byte array.");
        }
        byte[] encodedBuf = new byte[(strData.length + 2) / 3 * 4];
        int iDestIndex = 0;
        for (iSrcIndex = 0; iSrcIndex < strData.length - 2; iSrcIndex += 3) {
            encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex] >>> 2 & 0x3F];
            encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex + 1] >>> 4 & 0xF | strData[iSrcIndex] << 4 & 0x3F];
            encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex + 2] >>> 6 & 3 | strData[iSrcIndex + 1] << 2 & 0x3F];
            encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex + 2] & 0x3F];
        }
        if (iSrcIndex < strData.length) {
            encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex] >>> 2 & 0x3F];
            if (iSrcIndex < strData.length - 1) {
                encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex + 1] >>> 4 & 0xF | strData[iSrcIndex] << 4 & 0x3F];
                encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex + 1] << 2 & 0x3F];
            } else {
                encodedBuf[iDestIndex++] = mBase64EncMap[strData[iSrcIndex] << 4 & 0x3F];
            }
        }
        while (iDestIndex < encodedBuf.length) {
            encodedBuf[iDestIndex] = 61;
            ++iDestIndex;
        }
        String strResult = new String(encodedBuf);
        return strResult;
    }

    public static byte[] base64Decode(String strData) {
        int iDestIndex;
        if (strData == null || strData.length() == 0) {
            throw new IllegalArgumentException("Can not decode NULL or Empty string.");
        }
        byte[] byData = strData.getBytes();
        int tail = byData.length;
        while (byData[tail - 1] == 61) {
            --tail;
        }
        byte[] decodedBuf = new byte[tail - byData.length / 4];
        for (int i = 0; i < byData.length; ++i) {
            byData[i] = mBase64DecMap[byData[i]];
        }
        int iSrcIndex = 0;
        for (iDestIndex = 0; iDestIndex < decodedBuf.length - 2; iDestIndex += 3) {
            decodedBuf[iDestIndex] = (byte)(byData[iSrcIndex] << 2 & 0xFF | byData[iSrcIndex + 1] >>> 4 & 3);
            decodedBuf[iDestIndex + 1] = (byte)(byData[iSrcIndex + 1] << 4 & 0xFF | byData[iSrcIndex + 2] >>> 2 & 0xF);
            decodedBuf[iDestIndex + 2] = (byte)(byData[iSrcIndex + 2] << 6 & 0xFF | byData[iSrcIndex + 3] & 0x3F);
            iSrcIndex += 4;
        }
        if (iDestIndex < decodedBuf.length) {
            decodedBuf[iDestIndex] = (byte)(byData[iSrcIndex] << 2 & 0xFF | byData[iSrcIndex + 1] >>> 4 & 3);
        }
        if (++iDestIndex < decodedBuf.length) {
            decodedBuf[iDestIndex] = (byte)(byData[iSrcIndex + 1] << 4 & 0xFF | byData[iSrcIndex + 2] >>> 2 & 0xF);
        }
        return decodedBuf;
    }

    static {
        byte[] base64Map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        mBase64EncMap = base64Map;
        mBase64DecMap = new byte[128];
        for (int i = 0; i < mBase64EncMap.length; ++i) {
            Base64Utils.mBase64DecMap[Base64Utils.mBase64EncMap[i]] = (byte)i;
        }
    }
}

