/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.config;

import com.tcs.efiling.form.config.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class CheckSumHelper {
    private CheckSumHelper() {
    }

    public static void storeFolderHash(Map<File, Boolean> itrFilePaths) throws NoSuchAlgorithmException, IOException {
        for (File itrFilePath : itrFilePaths.keySet()) {
            if (!itrFilePaths.get(itrFilePath).booleanValue()) continue;
            String folderHash = CheckSumHelper.consolidatedFolderHash(itrFilePath);
            FileHelper.storeVersionProperties(itrFilePath, folderHash);
        }
    }

    public static String consolidatedFolderHash(File itrFilePath) throws IOException, NoSuchAlgorithmException {
        TreeSet<String> calHashes = new TreeSet<String>();
        for (File file : itrFilePath.listFiles()) {
            if (file.getName().equals("Version.properties") || file.getName().startsWith("E-Filing-") || file.getName().indexOf("ITRTemp.html") != -1) continue;
            String hash = CheckSumHelper.calculateHash(file);
            calHashes.add(hash);
        }
        String folderHash = CheckSumHelper.calculateFolderHash(calHashes);
        return folderHash;
    }

    private static String calculateFolderHash(Set<String> calHashes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        for (String hash : calHashes) {
            messageDigest.update(hash.getBytes());
        }
        byte[] mdbytes = messageDigest.digest();
        return CheckSumHelper.hexEncode(mdbytes);
    }

    private static String calculateHash(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = fis.read(dataBytes)) != -1) {
            messageDigest.update(dataBytes, 0, nread);
        }
        fis.close();
        byte[] mdbytes = messageDigest.digest();
        return CheckSumHelper.hexEncode(mdbytes);
    }

    private static String hexEncode(byte[] res) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = 0; i < res.length; ++i) {
            byte bytes = res[i];
            result.append(digits[(bytes & 0xF0) >> 4]);
            result.append(digits[bytes & 0xF]);
        }
        return result.toString();
    }
}

