/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;

public class PhoneNumberValidator
extends ValidatorInteface {
    private String stdCode;
    String initErrorCode = "";

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        int phoneNumberLength;
        String landlineNumber = null;
        if (this.initErrorCode.isEmpty()) {
            this.initErrorCode = this.getErrorCode();
        }
        if (val != null) {
            landlineNumber = val.toString();
        }
        String stdCodeField = validator.getFormValue(this.stdCode, name);
        String stdCodeValue = null;
        if (stdCodeField != null) {
            stdCodeValue = stdCodeField.toString();
        }
        if ((phoneNumberLength = ValidationUtil.getLengthOfString(stdCodeValue) + ValidationUtil.getLengthOfString(landlineNumber)) != 0) {
            if (phoneNumberLength != 10 && phoneNumberLength != 0) {
                this.setMessageKey(this.initErrorCode);
                this.addFieldError(name, validator);
            } else if (!ValidationUtil.isStringEmpty(stdCodeValue) && stdCodeValue.startsWith("0")) {
                if (this.stdCode.contains("fax")) {
                    this.setMessageKey("userDtls.faxStdCode.Improper");
                } else {
                    this.setMessageKey("userDtls.stdCode.Improper");
                }
                this.addFieldError(this.stdCode, validator);
            } else if (!ValidationUtil.isStringEmpty(landlineNumber) && landlineNumber.startsWith("0")) {
                if (this.stdCode.contains("fax")) {
                    this.setMessageKey("userDtls.faxNumber.beginZero.Improper");
                } else {
                    this.setMessageKey("userDtls.phoneNumber.beginZero.Improper");
                }
                this.addFieldError(name, validator);
            }
        }
    }

    public String getStdCode() {
        return this.stdCode;
    }

    public void setStdCode(String stdCode) {
        this.stdCode = stdCode;
    }
}

