/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validation.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.FieldValidatorRoot;
import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import com.tcs.efiling.form.validators.TableValidator;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.web.WebEngine;
import javax.xml.xpath.XPathConstants;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLElement;

public class Validator
extends Task<Void> {
    public static final Logger LOG = Logger.getLogger(Validator.class);
    public MainController mainController;
    boolean isTableCell = false;
    boolean isError = false;
    boolean isValidateCalled = false;
    private JSObject jSObject;
    private int count = 0;
    private double totalElementSize = 0.0;
    final int barToBeUpdatedCount = 30;
    static Map<String, String> FIELD_ERRORS = new LinkedHashMap<String, String>();
    static int pre = 0;
    static final int DISPLAY_FIELD_ERROR_COUNT = 10;
    String tempName2;
    public static Map<String, String> HTML_ELEMENTS = new LinkedHashMap<String, String>();
    public static boolean IS_SAVE = false;

    public static void main(String[] args) throws Exception {
        String str = "115j";
        String regex = "^[0-9a-zA-Z]{1,10}$";
    }

    public void blur(Object obj, String name, String val) {
        this.isTableCell = false;
        if (this.mainController.getPreviewButton().isDisable()) {
            this.mainController.getPreviewButton().setDisable(false);
        }
        try {
            val = val == null ? "" : val.trim();
            List<FieldValidatorRoot> fieldValidators = ValidationCacher.VALIDATION_MAP.get(name.replaceAll("\\[[0-9]*\\]", "[0]"));
            if (fieldValidators == null || fieldValidators != null && fieldValidators.isEmpty()) {
                LOG.warn("No validation for field: " + name);
                return;
            }
            this.removeErrors(name);
            for (FieldValidatorRoot field : fieldValidators) {
                ValidatorInteface validator = field.getValidator();
                validator.resetHasErrors();
                validator.validate(val, name, this);
                this.isError = validator.hasErrors();
                if (!this.isError || !validator.shortCircuit) continue;
                break;
            }
            if (!this.isError && name.indexOf("[") != -1) {
                this.validateTable(name, val);
            }
        }
        catch (Exception e) {
            LOG.error("blur error", e);
            LOG.warn("blur error for: type:  name: " + name);
        }
    }

    public void validateTable(String name, String val) throws Exception {
        String tableName = null;
        if (val != null && val.length() == 0) {
            String tempName = name.substring(0, name.lastIndexOf("["));
            tempName = tempName.replaceAll("\\[[0-9]*\\]", "[0]");
            LOG.info("This field is null:  name: " + tempName);
            List<FieldValidatorRoot> fieldValidators = ValidationCacher.VALIDATION_MAP.get(tempName);
            for (FieldValidatorRoot field : fieldValidators) {
                String actVal;
                TableValidator tableValidator = (TableValidator)field.validator;
                tableName = name.substring(0, name.lastIndexOf("["));
                String mandatoryFieldNames = tableValidator.getMandatoryFieldNames();
                String tableMandatory = tableValidator.getTableMandatory();
                String conAttributeName = tableValidator.getConAttributeName();
                String conAttributeValue = tableValidator.getConAttributeValue();
                String notMandate = tableValidator.getNotMadateFields();
                String conAttributeName2 = tableValidator.getConAttributeName2();
                String conAttributeValue2 = tableValidator.getConAttributeValue2();
                if (mandatoryFieldNames.trim().length() == 0) {
                    return;
                }
                String[] madateFields = mandatoryFieldNames.split(",");
                String[] notMandateArr = notMandate == null ? null : notMandate.split(",");
                String tempS = name.substring(name.lastIndexOf("]") + 2);
                boolean isContinue = false;
                for (String s : madateFields) {
                    if (!tempS.equals(s)) continue;
                    isContinue = true;
                    break;
                }
                if (!isContinue) {
                    return;
                }
                if (!ValidationUtil.isStringEmpty(conAttributeName) && (actVal = this.getFormValue(conAttributeName, name)).matches(conAttributeValue.trim())) {
                    tableMandatory = "Y";
                    if (!ValidationUtil.isStringEmpty(conAttributeName2)) {
                        String actVal2 = this.getFormValue(conAttributeName2, name);
                        tableMandatory = actVal2.matches(conAttributeValue2.trim()) ? "Y" : "N";
                    }
                }
                boolean isRowFull = false;
                if (tableMandatory.equals("Y")) {
                    isRowFull = true;
                } else {
                    String val1;
                    String temp1;
                    String tableName2 = name.substring(0, name.lastIndexOf("]") + 1);
                    for (String s : madateFields) {
                        temp1 = tableName2 + "." + s;
                        val1 = this.getFormValueTable(temp1);
                        if (val1 == null || val1.trim().length() == 0) continue;
                        isRowFull = true;
                        break;
                    }
                    if (notMandateArr != null) {
                        for (String s : notMandateArr) {
                            temp1 = tableName2 + "." + s;
                            val1 = this.getFormValueTable(temp1);
                            if (val1 == null || val1.trim().length() == 0) continue;
                            isRowFull = true;
                            break;
                        }
                    }
                }
                if (!isRowFull) continue;
                String tempField = name.substring(name.lastIndexOf("]") + 1);
                if (this.isValidateCalled) {
                    this.isError = true;
                    Validator.addFieldError2(name, this, ValidationCacher.getError(tempName + tempField + ".required"));
                    continue;
                }
                this.isError = true;
                ValidatorInteface.addFieldError(name, ValidationCacher.getError(tempName + tempField + ".required"));
            }
        }
    }

    public static void addFieldError2(String name, Validator validator, String errorMsg) {
        FIELD_ERRORS.put(name, ValidationCacher.getError(errorMsg));
    }

    public void removeErrors(String name) {
        this.tempName2 = name;
        if (!this.isValidateCalled) {
            this.mainController.getFormErrEngine().executeScript("removeErrors('" + name + "');");
            this.mainController.getItrEngine().executeScript("hideError();");
        }
    }

    public boolean shortCircuit(Node node, String name, String type) throws Exception {
        String prefix = "//field[@name='" + name + "']//field-validator[@type='" + type + "']//@short-circuit";
        String val = (String)ValidationCacher.xpath.evaluate(prefix, node, XPathConstants.STRING);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    public void validateAll(Object elems) {
        try {
            HTML_ELEMENTS.clear();
            long time1 = System.currentTimeMillis();
            Validator validator = new Validator();
            validator.jSObject = (JSObject)elems;
            validator.mainController = this.mainController;
            validator.isValidateCalled = true;
            int elementsCount = (Integer)validator.jSObject.getMember("length");
            for (int i = 0; i < elementsCount; ++i) {
                HTMLElement item = (HTMLElement)validator.jSObject.getSlot(i);
                Node n = item.getAttributes().getNamedItem("name");
                if (n == null) continue;
                HTML_ELEMENTS.put(n.getNodeValue(), ValidatorInteface.getFieldValue(item));
            }
            Validator.clearErrors(this.mainController.getFormErrEngine());
            Thread validatorTrhread = new Thread((Runnable)((Object)validator));
            validatorTrhread.start();
            long time2 = System.currentTimeMillis();
            LOG.info("Time taken in validateAll(): " + (time2 - time1) / 1000L);
        }
        catch (Exception e) {
            LOG.info("error in validateAll method  " + e);
        }
    }

    public static void clearErrors(WebEngine errEngine) {
        Document document = errEngine.getDocument();
        document.getElementById("errors").setTextContent("");
        document.getElementById("total").setTextContent("0");
        document.getElementById("start").setTextContent("0");
        document.getElementById("end").setTextContent("0");
    }

    protected Void call() throws Exception {
        try {
            LOG.debug("Call() starts : ");
            FIELD_ERRORS.clear();
            long time1 = System.currentTimeMillis();
            this.totalElementSize = HTML_ELEMENTS.size();
            Set<String> keySet = HTML_ELEMENTS.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key;
                String name = key = iterator.next();
                String val = HTML_ELEMENTS.get(name);
                this.blur(null, name, val);
                ++this.count;
                if (this.count <= 30 || this.count % 30 != 0) continue;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Validator.this.mainController.getVaidationBar().setProgress((double)Validator.this.count / Validator.this.totalElementSize);
                    }
                });
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Validator.this.mainController.getItrEngine().executeScript("validateOnSubmit()");
                    Validator.this.mainController.getVaidationBar().setProgress(1.0);
                    if (FIELD_ERRORS.isEmpty()) {
                        if (IS_SAVE) {
                            IS_SAVE = false;
                            File file = Validator.this.mainController.openFileDialog(true, ".xml", null);
                            if (file != null) {
                                Validator.this.mainController.generateXmlFlag = true;
                                Validator.this.mainController.setValidateSchemaFlag(true);
                                Validator.this.mainController.generateXml(file);
                                Validator.this.mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.xml.generate.success"), false);
                                Validator.this.mainController.getItrEngine().executeScript("setFileModifiedFalse()");
                            }
                        } else {
                            Validator.this.mainController.submitFORM();
                        }
                    } else {
                        String errorMsg = FormConfigUtil.getConfigProperty("msg.page.validated.with.error");
                        errorMsg = errorMsg.replace("number", FIELD_ERRORS.size() + "");
                        Validator.this.mainController.generateErrorDialog(errorMsg, true);
                        Set<String> keySet = FIELD_ERRORS.keySet();
                        for (String key : keySet) {
                            Validator.this.mainController.getFormErrEngine().executeScript("addErrors('" + key + "',\"" + FIELD_ERRORS.get(key) + "\");");
                        }
                    }
                    Validator.this.mainController.getFormErrEngine().executeScript("showErrors()");
                }
            });
            long time2 = System.currentTimeMillis();
            LOG.info("Call() ends time taken: " + (time2 - time1) + "  error count :" + FIELD_ERRORS.size());
        }
        catch (Exception e) {
            LOG.error("error ", e);
        }
        return null;
    }

    public String getFormValue(String name, String orginalField) {
        if (name == null || name != null && name.trim().length() == 0) {
            return null;
        }
        if (orginalField.indexOf("[") != -1) {
            name = name.replace("[0]", orginalField.substring(orginalField.indexOf("["), orginalField.indexOf("]") + 1));
        }
        if (this.isValidateCalled) {
            return HTML_ELEMENTS.get(name);
        }
        String element = "document.getElementsByName('" + name + "')[0].value;";
        return (String)this.mainController.getItrEngine().executeScript(element);
    }

    public String getFormValueTable(String name) {
        if (name == null || name != null && name.trim().length() == 0) {
            return null;
        }
        if (this.isValidateCalled) {
            return HTML_ELEMENTS.get(name);
        }
        String element = "document.getElementsByName('" + name + "')[0].value;";
        return (String)this.mainController.getItrEngine().executeScript(element);
    }

    public String getErrorMsg(String xpathStr, Node doc) throws Exception {
        String errorMsg = "";
        try {
            errorMsg = (String)ValidationCacher.xpath.evaluate(xpathStr, doc, XPathConstants.STRING);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        return errorMsg;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setFieldError(String name, String error) {
        try {
            error = error.replaceAll("\"", "\\\"");
            this.mainController.getFormErrEngine().executeScript("addErrors('" + name + "',\"" + error + "\");");
            FIELD_ERRORS.put(name, error);
        }
        catch (Exception e) {
            LOG.error("Error in setFieldError() for name:" + name + "error :" + error);
        }
    }

    public void setWarnings(String name, String warn) {
        try {
            warn = warn.replaceAll("\"", "\\\"");
            this.mainController.getFormErrEngine().executeScript("addWarnings('" + name + "',\"" + warn + "\");");
        }
        catch (Exception e) {
            LOG.error("Error in setWarnings() for name:" + name + "warn :" + warn);
        }
    }
}

