/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.DownloadFORMV;
import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.FormUploadRequest;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.SubmitFORMRequest;
import com.tcs.efiling.form.main.CommonUtil;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.SubmitFORMDialogController;
import com.tcs.efiling.form.main.SubmitFORMSuccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WebServiceUtilSingle
extends Task<Void> {
    static final Logger LOG = Logger.getLogger(WebServiceUtilSingle.class);
    static SOAPConnectionFactory soapConnectionFactory;
    static SOAPConnection soapConnection;
    static String url;
    static MainController mainController;
    static File itrFile;
    static String asstYear;
    static String itrName;
    static String ver;
    static File pfxFile;
    static boolean is15CA;
    String faultString;
    String formName;
    String transactionId;
    String emailId;
    String caEmailId;
    String ackNo;
    static boolean isUnderProcess;
    public static SubmitFORMRequest submitFORMRequest;
    static FormUploadRequest request15CA;
    public static SubmitFORMDialogController controller;
    static DownloadFORMV downloadFORMV;
    static JAXBContext submitFORMContext;
    static JAXBContext itrvContext;
    public static Map<String, File> ALL_ATTACHMENTS;
    String msg;
    File itrvFile;
    static List<String> schemaError;
    static DocumentBuilderFactory dbf;

    public static void init() {
        try {
            if (soapConnectionFactory == null) {
                soapConnectionFactory = SOAPConnectionFactory.newInstance();
                soapConnection = soapConnectionFactory.createConnection();
                url = FormConfigUtil.getConfigProperty("webservice.url");
                if (FormConfigUtil.getFormNamesIndCo().containsKey(MainController.itrName)) {
                    submitFORMContext = JAXBContext.newInstance((Class[])new Class[]{FormUploadRequest.class});
                } else {
                    LOG.debug("Init for Forms other than 15CA");
                    submitFORMContext = JAXBContext.newInstance((Class[])new Class[]{SubmitFORMRequest.class});
                }
                LOG.info("webservie url: " + url);
            }
        }
        catch (Exception e) {
            LOG.error("Error in init", e);
        }
    }

    public SOAPMessage sendSoapMessage(boolean isAttachment, JAXBContext context, Object obj) throws Exception {
        LOG.info("sendSoapMessage starts with obj: " + obj + " ,isAttachment: " + isAttachment);
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage request = messageFactory.createMessage();
        SOAPPart soapPart = request.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody soapBody = envelope.getBody();
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(obj, (Node)soapBody);
        File zipFile = this.createZipFile();
        if (isAttachment) {
            DataHandler dh = new DataHandler((DataSource)new FileDataSource(zipFile));
            AttachmentPart attachment = request.createAttachmentPart(dh);
            request.addAttachmentPart(attachment);
        }
        LOG.info("url:" + url);
        SOAPMessage response = soapConnection.call(request, (Object)url);
        return response;
    }

    public File createZipFile() throws Exception {
        LOG.info("Inside createZipFile");
        SecureRandom secureRandom = new SecureRandom();
        int random = secureRandom.nextInt();
        String zipFileName = "FormUpload" + random;
        File tempFile = File.createTempFile(zipFileName, ".zip");
        FileInputStream fis = new FileInputStream(itrFile);
        FileOutputStream fos = new FileOutputStream(tempFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        ZipEntry zipEntry = new ZipEntry(itrFile.getName());
        zos.putNextEntry(zipEntry);
        int read = 0;
        while ((read = fis.read()) != -1) {
            zos.write(read);
        }
        zos.closeEntry();
        if (!ALL_ATTACHMENTS.isEmpty()) {
            LOG.info("ALL_ATTACHMENTS: " + ALL_ATTACHMENTS);
            for (String key : ALL_ATTACHMENTS.keySet()) {
                LOG.info("key in ALL_ATTACHMENTS: " + key);
                File tempAttach = ALL_ATTACHMENTS.get(key);
                zipEntry = new ZipEntry(key + "_" + tempAttach.getName());
                fis = new FileInputStream(tempAttach);
                zos.putNextEntry(zipEntry);
                while ((read = fis.read()) != -1) {
                    zos.write(read);
                }
                fis.close();
                zos.closeEntry();
            }
        }
        zos.close();
        fos.close();
        LOG.info("tempFile:" + tempFile.getAbsolutePath());
        return tempFile;
    }

    public void sendRequest() {
        if (FormUtil.isConnected()) {
            LOG.info("sendRequest starts");
            try {
                schemaError.clear();
                SOAPMessage response = null;
                response = !is15CA ? this.sendSoapMessage(true, submitFORMContext, submitFORMRequest) : this.sendSoapMessage(true, submitFORMContext, request15CA);
                response.writeTo((OutputStream)System.out);
                SOAPBody resBody = response.getSOAPPart().getEnvelope().getBody();
                CommonUtil.writeSoapToLog(LOG, response);
                SOAPFault soapFault = resBody.getFault();
                LOG.info("Soap fault: " + soapFault);
                if (soapFault != null) {
                    String faultActor = soapFault.getFaultActor();
                    this.faultString = soapFault.getFaultString();
                    if (this.faultString != null && this.faultString.indexOf("error.") != -1) {
                        this.faultString = FormConfigUtil.getConfigProperty(this.faultString);
                    }
                    String faultCode = soapFault.getFaultCode();
                    String error = "FaultActor: " + faultActor + "<br/>FaultCode: " + faultCode + "<br/>Fault: " + this.faultString;
                    schemaError.add(error);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            controller.setErrorText(WebServiceUtilSingle.this.faultString);
                        }
                    });
                } else {
                    if (is15CA) {
                        this.transactionId = resBody.getElementsByTagName("Result").item(0).getTextContent();
                        if (resBody.getElementsByTagName("AckNo").item(0) != null) {
                            this.ackNo = resBody.getElementsByTagName("AckNo").item(0).getTextContent();
                            SubmitFORMSuccessController.setAckNo(this.ackNo);
                        }
                        if (resBody.getElementsByTagName("EmailId").item(0) != null) {
                            this.emailId = resBody.getElementsByTagName("EmailId").item(0).getTextContent();
                            SubmitFORMSuccessController.setEmailId(this.emailId);
                        }
                        LOG.info("transactionId: " + this.transactionId);
                        LOG.info("ackNo: " + this.ackNo);
                        SubmitFORMSuccessController.setTransactionId(this.transactionId);
                        SubmitFORMSuccessController.setFormName(request15CA.getFormName());
                    } else {
                        LOG.info("Before setting from response");
                        this.formName = resBody.getElementsByTagName("FormName").item(0).getTextContent();
                        this.caEmailId = resBody.getElementsByTagName("CaEmailId").item(0).getTextContent();
                        this.transactionId = resBody.getElementsByTagName("TransactionId").item(0).getTextContent();
                        this.emailId = resBody.getElementsByTagName("EmailId").item(0).getTextContent();
                        LOG.info("formName: " + this.formName + " ,transactionId:" + this.transactionId + ",emailId:" + this.emailId + "caEmailId:" + this.caEmailId);
                        SubmitFORMSuccessController.setEmailId(this.emailId);
                        SubmitFORMSuccessController.setCaEmailId(this.caEmailId);
                        SubmitFORMSuccessController.setTransactionId(this.transactionId);
                        SubmitFORMSuccessController.setFormName(submitFORMRequest.getFormName());
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            controller.cancel();
                            try {
                                mainController.generateSubmitFORMSuccess();
                            }
                            catch (Exception e) {
                                LOG.error("errori ", e);
                                mainController.generateErrorDialog(e.getMessage(), true);
                            }
                        }
                    });
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.getProgress().setProgress(1.0);
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Error in sendRequest: ", e);
                final String errorSubmit = e.getMessage();
                schemaError.add(e.getMessage());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.setErrorText(errorSubmit == null ? "Service Unavailable.Please Try later" : errorSubmit);
                        controller.getProgress().setProgress(1.0);
                    }
                });
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    controller.setErrorText(FormConfigUtil.getConfigProperty("form.net.error"));
                    controller.getProgress().setProgress(1.0);
                }
            });
        }
    }

    public Object getSchemaErrors() {
        if (schemaError.isEmpty()) {
            return FormConfigUtil.getConfigProperty("no.schema.error");
        }
        return schemaError;
    }

    public void browse() {
        try {
            LOG.info("Browse starts webServiceEngine:");
            itrFile = mainController.openFileDialog(false, ".xml", null);
            if (itrFile != null) {
                this.setFORMFileConfig();
            }
        }
        catch (Exception e) {
            mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("invalid.xml.file"), true);
            LOG.error("browse error", e);
        }
    }

    public void setFORMFileConfig() throws Exception {
        FormCacher.initDoc(itrFile.getAbsolutePath());
        FormUtil itrUtil = new FormUtil();
        asstYear = itrUtil.getAsstYear();
        itrName = itrUtil.getFORMName();
        String verficationPan = FormUtil.getVerificationPAN();
        String dob = FormUtil.getDOB();
        String userPan = FormUtil.getPAN();
        LOG.info("asstYear: " + asstYear + ",itrName" + itrName + ",verficationPan:" + verficationPan + ",dob:" + dob + ",userPan:" + userPan);
    }

    protected Void call() throws Exception {
        try {
            WebServiceUtilSingle.init();
            LOG.info("Thread call starts");
            long time1 = System.currentTimeMillis();
            this.sendRequest();
            long time2 = System.currentTimeMillis();
            LOG.info("Thread call ends : time taken: " + (time2 - time1));
        }
        catch (Exception e) {
            LOG.error("Error in call function", e);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                controller.getSubmit().setDisable(false);
            }
        });
        return null;
    }

    public void keyStoreFile() {
        pfxFile = mainController.openFileDialog(false, ".pfx,.p12", null);
        if (pfxFile != null) {
            // empty if block
        }
    }

    public static void hexWriteToFile(String hexStr, File fileToWrite) throws Exception {
        LOG.info("Writing to file: " + fileToWrite.getAbsolutePath());
        FileOutputStream fos = new FileOutputStream(fileToWrite);
        fos.write(WebServiceUtilSingle.decode(hexStr.getBytes()));
        fos.close();
    }

    public static byte[] decode(byte[] data) {
        int j = 0;
        byte[] result = new byte[data.length / 2];
        int i = 0;
        while (i < data.length) {
            byte b;
            byte c = data[i++];
            byte d = data[i++];
            if (c >= 48 && c <= 57) {
                b = (byte)(c - 48 << 4);
            } else if (c >= 65 && c <= 70) {
                b = (byte)(c - 65 + 10 << 4);
            } else if (c >= 97 && c <= 102) {
                b = (byte)(c - 97 + 10 << 4);
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + c);
            }
            if (d >= 48 && d <= 57) {
                b = (byte)(b + (byte)(d - 48));
            } else if (d >= 65 && d <= 70) {
                b = (byte)(b + (byte)(d - 65 + 10));
            } else if (d >= 97 && d <= 102) {
                b = (byte)(b + (byte)(d - 97 + 10));
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + d);
            }
            result[j++] = b;
        }
        return result;
    }

    public MainController getMainController() {
        return mainController;
    }

    public void setMainController(MainController mainController) {
        WebServiceUtilSingle.mainController = mainController;
    }

    public static File getItrFile() {
        return itrFile;
    }

    public static void setItrFile(File itrFile) {
        WebServiceUtilSingle.itrFile = itrFile;
    }

    static {
        url = "";
        is15CA = false;
        isUnderProcess = false;
        submitFORMRequest = new SubmitFORMRequest();
        request15CA = new FormUploadRequest();
        downloadFORMV = new DownloadFORMV();
        submitFORMContext = null;
        itrvContext = null;
        ALL_ATTACHMENTS = new HashMap<String, File>();
        schemaError = new ArrayList<String>();
        dbf = DocumentBuilderFactory.newInstance();
    }
}

