/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.Download;
import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.UpdateController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class UpdateUtil
extends Task<Void> {
    static final Logger LOG = Logger.getLogger(UpdateUtil.class);
    public static String itr_config_url = "";
    public static boolean UPDATE_RUNNING;
    static MainController mainController;
    static UpdateController updateController;
    String location;
    static Timeline timeLine;
    File downloadFile;
    static String itr;
    static String asstYear;
    static String version;
    static String hash;
    boolean isError = false;
    String fileType = "";

    public static void loadURL() {
        itr_config_url = FormConfigUtil.getConfigProperty("itr.config.url");
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", null);
        map.put("1", "1");
        System.out.println("" + map);
    }

    protected Void call() throws Exception {
        LOG.info("call starts");
        UPDATE_RUNNING = true;
        long time1 = System.currentTimeMillis();
        try {
            UpdateUtil.loadURL();
            this.getServerData();
        }
        catch (Exception e) {
            LOG.error("call ends with error ", e);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UpdateUtil.updateController.updateText.setText(FormConfigUtil.getConfigProperty("error.reading.downloaded.file"));
                }
            });
        }
        long time2 = System.currentTimeMillis();
        UPDATE_RUNNING = false;
        LOG.info("call ends, time taken : " + (time2 - time1));
        return null;
    }

    public void getServerData() throws Exception {
        URL getUrl = new URL(itr_config_url);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "Java_Utility");
        connection.setRequestProperty("Accept-Language", "en-US,en");
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
        out.write("itr=" + itr);
        out.write("&asstYear=" + asstYear.substring(0, 4));
        out.write("&version=" + version);
        out.write("&hash=" + hash);
        out.close();
        InputStream inputStream = connection.getInputStream();
        File serverXml = File.createTempFile("serverxml", ".xml");
        FileOutputStream bos = new FileOutputStream(serverXml);
        int read = 0;
        while ((read = inputStream.read()) != -1) {
            bos.write(read);
        }
        bos.close();
        inputStream.close();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Download.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Download download = (Download)unmarshaller.unmarshal(serverXml);
        String isCurrVersion = download.getCurentVersion();
        if ("Y".equals(isCurrVersion)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (updateController != null) {
                        UpdateUtil.updateController.progessbar.setProgress(1.0);
                        UpdateUtil.updateController.updateText.setText(FormConfigUtil.getConfigProperty("itr.version.latest"));
                    }
                }
            });
        } else {
            this.fileType = download.getFileType();
            this.location = download.getLocation();
            this.downloadFile = File.createTempFile("ITR_Update", this.fileType);
            LOG.info("downloadFile : " + this.downloadFile.getAbsolutePath() + " ,location: " + this.location + " ,fileType: " + this.fileType);
            LOG.info("itr utility location " + this.location);
            URL downloadLocation = new URL(this.location);
            HttpURLConnection downloadConnection = (HttpURLConnection)downloadLocation.openConnection();
            InputStream inputStream1 = downloadConnection.getInputStream();
            FileOutputStream fos = new FileOutputStream(this.downloadFile);
            while ((read = inputStream1.read()) != -1) {
                fos.write(read);
            }
            fos.close();
            inputStream1.close();
            LOG.info("download finished: ");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (updateController != null) {
                        updateController.setLocation(UpdateUtil.this.location);
                        UpdateUtil.updateController.progessbar.setProgress(1.0);
                        UpdateUtil.updateController.progessbar.setVisible(false);
                        updateController.setDownloadedFile(UpdateUtil.this.downloadFile);
                        updateController.setFileType(UpdateUtil.this.fileType);
                        updateController.getDownload().setVisible(true);
                        UpdateUtil.updateController.updateText.setText(FormConfigUtil.getConfigProperty("itr.version.new.downloaded"));
                    }
                }
            });
        }
    }

    public MainController getMainController() {
        return mainController;
    }

    public static void setMainController(MainController mainController1) {
        mainController = mainController1;
    }

    public static UpdateController getUpdateController() {
        return updateController;
    }

    public static void setUpdateController(UpdateController updateController) {
        UpdateUtil.updateController = updateController;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public void setDownloadFile(File downloadFile) {
        this.downloadFile = downloadFile;
    }

    public String getItr() {
        return itr;
    }

    public void setItr(String itr) {
        UpdateUtil.itr = itr;
    }

    public String getAsstYear() {
        return asstYear;
    }

    public void setAsstYear(String asstYear) {
        UpdateUtil.asstYear = asstYear;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        UpdateUtil.version = version;
    }

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        UpdateUtil.hash = hash;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

