/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class SaveFORMDialogController
implements Initializable {
    private Stage myDialogStage;
    MainController mainController;
    int type;
    @FXML
    ImageView exitImg;
    static final Logger LOG = Logger.getLogger(SaveFORMDialogController.class);

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.exitImg.setImage(new Image(FormConfigUtil.getImage("toolbar/exit.png")));
        }
        catch (Exception e) {
            LOG.error("error in initialize: ", e);
        }
    }

    @FXML
    public void hide() {
        this.myDialogStage.hide();
    }

    @FXML
    public void saveFORM() {
        LOG.info("saveFORM starts saving file");
        this.mainController.saveFile();
        this.cancel();
    }

    @FXML
    public void cancel() {
        this.myDialogStage.hide();
        if (this.type == 3) {
            LOG.debug("type 3: load new itr home");
            this.mainController.loadHomePage();
        } else if (this.type == 4) {
            File file = this.mainController.openFileDialog(false, ".xml", null);
            this.mainController.startImport(file);
        }
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

