/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.Base64Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.soap.SOAPMessage;

public class CommonUtil {
    static final Logger LOG = Logger.getLogger(CommonUtil.class);

    public static void main(String[] args) {
        System.out.println("hash " + CommonUtil.getHash());
    }

    public static String getHash() {
        String hash = null;
        try {
            byte[] b;
            MessageDigest md = MessageDigest.getInstance("MD5");
            File locationJar = new File(CommonUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            FileInputStream fis = new FileInputStream(locationJar);
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                int size = bis.available();
                b = new byte[size];
                bis.read(b);
            }
            byte[] digest = md.digest(b);
            hash = Base64Utils.base64Encode(digest);
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException e) {
            LOG.error("error in getHash", e);
        }
        LOG.info("hash is : " + hash);
        return hash;
    }

    public static void writeSoapToLog(Logger LOG, SOAPMessage soapMessage) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bout);
            String msg = bout.toString("UTF-8");
            LOG.info("soapMessage " + msg);
            bout.close();
        }
        catch (Exception e) {
            LOG.error("error writing soap ", e);
        }
    }
}

