/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.config;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.UsbTokenModel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class UsbTokenUtil {
    private static final String KEYSTORE_INSTANCE_TYPE = "Windows-MY";
    static final Logger LOG = Logger.getLogger(UsbTokenUtil.class);
    public static KeyStore keyStore = null;

    public static void main(String[] args) throws Exception {
        System.out.println("getUsbTokenData: " + UsbTokenUtil.getUsbTokenData());
    }

    public static Map<String, UsbTokenModel> getUsbTokenData() throws Exception {
        HashMap<String, UsbTokenModel> tokenList = new HashMap<String, UsbTokenModel>();
        try {
            keyStore = KeyStore.getInstance(KEYSTORE_INSTANCE_TYPE);
        }
        catch (KeyStoreException ke) {
            throw new Exception(ke.getMessage());
        }
        keyStore.load(null, null);
        Enumeration<String> aliases = keyStore.aliases();
        String alias = null;
        aliases = keyStore.aliases();
        if (!aliases.hasMoreElements()) {
            throw new Exception("The KeyStore is empty");
        }
        Vector<String> jList = new Vector<String>();
        while (aliases.hasMoreElements()) {
            alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            jList.add(alias);
        }
        if (jList.size() <= 0) {
            throw new GeneralSecurityException("No Certificate found in your keystore");
        }
        for (String aliasTemp : jList) {
            UsbTokenModel model = new UsbTokenModel();
            Certificate certi = keyStore.getCertificate(aliasTemp);
            X509Certificate x509cert = (X509Certificate)certi;
            model.setIssuedTo(x509cert.getSubjectDN().getName());
            model.setIssuedBy(x509cert.getIssuerDN().getName());
            model.setValidForm(x509cert.getNotBefore().toString());
            model.setValidTill(x509cert.getNotAfter().toString());
            tokenList.put(aliasTemp, model);
        }
        LOG.info("tokenList: " + tokenList);
        return tokenList;
    }
}

