/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.config;

import com.tcs.efiling.form.config.Form;
import com.tcs.efiling.form.config.Forms;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.SavedXmlRoot;
import com.tcs.efiling.form.main.MainController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class FormConfigUtil {
    static final Logger LOG = Logger.getLogger(FormConfigUtil.class);
    public static Map<String, Set<String>> FORM_ASSTYEAR = new TreeMap<String, Set<String>>();
    public static Map<String, Set<String>> FORM_NAME_LIST = new TreeMap<String, Set<String>>();
    public static Map<String, Set<String>> ASSTYEAR_FORM = new LinkedHashMap<String, Set<String>>();
    private static MainController mainController;
    public static Map<String, Form> FORM_CONFIG;
    static JAXBContext context;
    static Unmarshaller unmarshaller;
    static Marshaller marshaller;
    static SavedXmlRoot savedXmlRoot;
    static final String inputFormat = "dd/MM/yyyy HH:mm:ss";
    public static final SimpleDateFormat DD_MM_YYYY_HH_MM_SS;
    public static final List<String> DELETE_NODE_GENERATE_XML;
    private static Properties config_properties;
    private static Properties version_properties;
    private static Map<String, String> IMPORT_MULTIPLE_ROOT;
    private static Map<String, String> IMPORT_MULTIPLE_VALUES;
    public static Map<String, String> EXPORT_MULTIPLE_VALUES;
    public static Map<String, String> ALL_FORMS;
    public static Map<String, String> FORMS_INCO_FILED;
    public static Map<String, String> FORMS_DSC_REQD;
    public static List<String> SAME_TAG_FORMS;
    public static final String CURRENT_AY = "Current A.Y";
    static Forms forms;
    public static Properties IMPORT_MULTIPLE;
    public static Properties EXPORT_MULTIPLE;

    public static void loadConfigProperties() {
        try {
            config_properties.load(FormConfigUtil.getConfigURL());
            version_properties.load(FormConfigUtil.getVersionConfigURL());
            FormConfigUtil.getSameTagForms();
        }
        catch (Exception e) {
            LOG.error("Error in loadConfigProperties: ", e);
        }
    }

    public static boolean isFormValidToFile(String formName, String asstYear) {
        boolean flag = false;
        if (ALL_FORMS.containsKey(formName)) {
            if (asstYear == null || asstYear.length() == 0) {
                flag = true;
            } else if (ALL_FORMS.get(formName).equals(asstYear)) {
                flag = true;
            }
        }
        LOG.info("isFormValidToFile ends with: " + flag);
        return flag;
    }

    public static String getConfigProperty(String key) {
        return config_properties.getProperty(key) == null ? key : config_properties.getProperty(key);
    }

    public static String getFormVersion(String form) {
        return version_properties.getProperty(form) == null ? form : version_properties.getProperty(form);
    }

    public static String getFormName(String form) {
        String formName = form.substring(4);
        form = "FORM " + formName;
        return version_properties.getProperty(form) == null ? form : version_properties.getProperty(form);
    }

    public static void initFORMConfig() {
        FormConfigUtil.loadConfigProperties();
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest mf4;
                    Attributes mainAttribs;
                    URL url = resEnum.nextElement();
                    LOG.info("url " + url);
                    InputStream is = url.openStream();
                    if (is == null || (mainAttribs = (mf4 = new Manifest(is)).getMainAttributes()).getValue("assessment-year") == null) continue;
                    MainController.asstYear = mainAttribs.getValue("assessment-year");
                    MainController.itrName = mainAttribs.getValue("form");
                    MainController.isCaFlag = mainAttribs.getValue("caFlag");
                    LOG.info(MainController.asstYear + " :: " + MainController.itrName + " :: " + MainController.version);
                    return;
                }
                catch (Exception e) {
                    LOG.error("Error in initITRConfig()", e);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean importMultiple(String formName, String asstYear, String version) {
        LOG.info("importMultiple starts");
        boolean flag = false;
        try {
            IMPORT_MULTIPLE = new Properties();
            InputStream is = FormConfigUtil.getResourceStream(FormConfigUtil.getActulaJarPath() + "/" + formName + "/" + asstYear + "/" + version + "/Import_Multiple.properties");
            if (is != null) {
                IMPORT_MULTIPLE.load(is);
                Set<Object> set = IMPORT_MULTIPLE.keySet();
                int count = 1;
                while (true) {
                    String path = "Root" + count;
                    String xpath = (String)IMPORT_MULTIPLE.get(path);
                    ++count;
                    if (xpath == null) break;
                    IMPORT_MULTIPLE_ROOT.put(xpath, xpath);
                    String rootPath = path + ".rootXpath";
                    IMPORT_MULTIPLE_VALUES.put((String)IMPORT_MULTIPLE.get(rootPath), rootPath);
                }
                LOG.info("IMPORT_MULTIPLE_ROOT: " + IMPORT_MULTIPLE_ROOT);
                LOG.info("IMPORT_MULTIPLE_VALUES: " + IMPORT_MULTIPLE_VALUES);
            }
            if (!IMPORT_MULTIPLE_VALUES.isEmpty()) {
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.error("importMultiple error", e);
        }
        LOG.info("importMultiple ends with flag " + flag);
        return flag;
    }

    public static boolean exportMultiple(String formName, String asstYear, String version) {
        LOG.info("exportMultiple starts");
        boolean flag = false;
        try {
            if (!EXPORT_MULTIPLE_VALUES.isEmpty()) {
                return true;
            }
            EXPORT_MULTIPLE = new Properties();
            InputStream es = FormConfigUtil.getResourceStream(FormConfigUtil.getActulaJarPath() + "/" + formName + "/" + asstYear + "/" + version + "/Export_Multiple.properties");
            if (es != null) {
                EXPORT_MULTIPLE.load(es);
                Set<Object> set = EXPORT_MULTIPLE.keySet();
                for (Object key : set) {
                    EXPORT_MULTIPLE_VALUES.put(((String)key).replaceAll("-", ":"), ((String)EXPORT_MULTIPLE.get(key)).replaceAll("-", ":"));
                }
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.error("importMultiple error", e);
        }
        return flag;
    }

    public static boolean isEligible(String xpath) {
        boolean flag = false;
        for (String val : IMPORT_MULTIPLE_VALUES.keySet()) {
            if (!xpath.startsWith(val)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static String getImportMultipleXpath(String type) {
        return (String)IMPORT_MULTIPLE.get(type);
    }

    public static void addKeystore() {
        try {
            String keyStorepath = FormConfigUtil.getActulaJarPath() + "/Config/efilekeystore.keystore";
            InputStream is = FormConfigUtil.getResourceStream(keyStorepath);
            File tempKeyStore = File.createTempFile("incometax_keystore", "keystore");
            FileOutputStream fos = new FileOutputStream(tempKeyStore);
            byte[] b = new byte[is.available()];
            is.read(b);
            fos.write(b);
            is.close();
            fos.close();
            System.setProperty("javax.net.ssl.keyStore", tempKeyStore.getAbsolutePath());
            System.setProperty("javax.net.ssl.keyStorePassword", "Saras@1234");
            tempKeyStore.deleteOnExit();
        }
        catch (Exception e) {
            LOG.error("error in addkeystore,", e);
        }
    }

    public static Forms getFORMConfigXml() {
        return forms;
    }

    public static boolean isCaFlag(String formName, String asYear, String isCaFlag) {
        if (formName.equalsIgnoreCase("FORM64")) {
            MainController.asstYear = "2014-15";
        } else if (formName.equalsIgnoreCase("FORM64A")) {
            MainController.asstYear = "2015-16";
        } else if (formName.equalsIgnoreCase("FORM64D")) {
            MainController.asstYear = "2015-16";
        } else if (formName.equalsIgnoreCase("FORM6")) {
            MainController.asstYear = "2015-16";
        } else if (formName.equalsIgnoreCase("FORM61B")) {
            MainController.asstYear = "2015-16";
        } else if (formName.equalsIgnoreCase("FORM64E")) {
            MainController.asstYear = "2017-18";
        }
        return "Y".equals(isCaFlag);
    }

    public static Set<String> getAsstYearForFORM(String itr) {
        return FORM_ASSTYEAR.get(itr);
    }

    public static Set<String> getFORMs() {
        return FORM_ASSTYEAR.keySet();
    }

    public static void main(String[] args) {
        FormConfigUtil.initFORMConfig();
    }

    public static String getVersion(String itr, String asstYear) {
        return MainController.version;
    }

    public static String getActulaJarPath() {
        return "./FORM";
    }

    public static void loadDeleteNodeGenerateXml(String itrName, String asstYear, String ver) throws Exception {
        if (FormConfigUtil.getDeleteNodeGenereteXml(itrName, asstYear, ver) != null) {
            Properties properties = new Properties();
            properties.load(FormConfigUtil.getDeleteNodeGenereteXml(itrName, asstYear, ver));
            Set<Object> keySet = properties.keySet();
            for (Object obj : keySet) {
                String key = obj.toString();
                String node = properties.getProperty(key);
                DELETE_NODE_GENERATE_XML.add(node);
            }
        }
    }

    public static Map<String, String> getFormNamesIndCo() {
        try {
            String[] formNames;
            config_properties.load(FormConfigUtil.getConfigURL());
            for (String fNames : formNames = config_properties.getProperty("form.indco.submit").split(",")) {
                FORMS_DSC_REQD.put(fNames, fNames);
            }
            LOG.info("List of Form Names:" + FORMS_DSC_REQD);
        }
        catch (Exception ex) {
            LOG.info("Error in getFormNamesIndCo: " + ex);
        }
        return FORMS_DSC_REQD;
    }

    public static Map<String, String> getFormNamesDscMndtry() {
        try {
            String[] formNames;
            config_properties.load(FormConfigUtil.getConfigURL());
            for (String fNames : formNames = config_properties.getProperty("form.dsc.mandatory").split(",")) {
                FORMS_INCO_FILED.put(fNames, fNames);
            }
            LOG.info("List of Form Names:" + FORMS_INCO_FILED);
        }
        catch (Exception ex) {
            LOG.info("Error in getFormNamesIndCo: " + ex);
        }
        return FORMS_INCO_FILED;
    }

    public static void getSameTagForms() {
        try {
            config_properties.load(FormConfigUtil.getConfigURL());
            String[] formNames = config_properties.getProperty("form.sametags.in.different.tables").split(",");
            SAME_TAG_FORMS.addAll(Arrays.asList(formNames));
            LOG.info("List of Form Names:" + formNames);
        }
        catch (Exception ex) {
            LOG.info("Error in getSameTagForms: " + ex);
        }
    }

    public static String getHtmlFile(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/SubmitFORM.html";
        return FormConfigUtil.getExternalForm(path);
    }

    public static InputStream getAdditionsCSVFile(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Additions_Template.csv";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getDeductionsCSVFile(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Deductions_Template.csv";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getCSVTemplates(String itr, String asstYear, String ver, String tableId) {
        String path = null;
        if (tableId.equals("pt21biaTable") || tableId.equals("pt21biiaTable") || tableId.equals("pt21biiaLevyTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template1_3.csv";
        } else if (tableId.equals("pt21bibTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template2.csv";
        } else if (tableId.equals("pt21biibTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template4.csv";
        } else if (tableId.equals("pt21biibLevyTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template6.csv";
        } else if (tableId.equals("pt21bviaTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template5.csv";
        } else if (tableId.equals("pt20Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_20b.csv";
        } else if (tableId.equals("pt34cTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_34c.csv";
        } else if (tableId.equals("pt31aTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_31a.csv";
        } else if (tableId.equals("pt31bTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_31b.csv";
        } else if (tableId.equals("pt34bTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_34b.csv";
        } else if (tableId.equals("pt26iAaTable") || tableId.equals("pt26iAbTable") || tableId.equals("pt26iBaTable") || tableId.equals("pt26iBbTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_26.csv";
        } else if (tableId.equals("pt34aTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_34a.csv";
        } else if (tableId.equals("pt15Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_point15.csv";
        } else if (tableId.equals("pt5Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Template_point5.csv";
        } else if (tableId.equals("form5Annex5pt1Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Bank_Account_Point1.csv";
        } else if (tableId.equals("form5Annex5pt2Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Immovable_Property_Point2.csv";
        } else if (tableId.equals("form5Annex5pt4Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Artistic_Work_Point4.csv";
        } else if (tableId.equals("form5Annex5pt5aTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Shares_Details_Point5a.csv";
        } else if (tableId.equals("form5Annex5pt5bTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Shares_Details_Point5b.csv";
        } else if (tableId.equals("form5Annex5pt5cTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Shares_Details_Point5c.csv";
        } else if (tableId.equals("form5Annex5pt6Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Any_Other_Assets_Point6.csv";
        } else if (tableId.equals("form5Annex5pt3aTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Gold_Details_Point3a.csv";
        } else if (tableId.equals("form5Annex5pt3bTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Gold_Details_Point3b.csv";
        } else if (tableId.equals("form5Annex5pt3cTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Gold_Details_Point3c.csv";
        } else if (tableId.equals("form5Annex5pt3dTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Gold_Details_Point3d.csv";
        } else if (tableId.equals("form64Dpoint6Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/PartnerTrustDtl_Point6.csv";
        } else if (tableId.equals("form64Dpt12Table")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Section115UBUnitHolder_Point10.csv";
        } else if (tableId.equals("form64Dpt12iiTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/UnitsHeldMoreThan12Mnths_Point12ii.csv";
        } else if (tableId.equals("form64Dpt12iiiTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/DeemedLoss31stMar.csv";
        } else if (tableId.equals("form64ETrusteeTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/Trustee.csv";
        } else if (tableId.equals("form64EInvestorTable")) {
            path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/CSV_Templates/UnitInvestor.csv";
        }
        return FormConfigUtil.getResourceStream(path);
    }

    public static String getHtmlFileEncrypt(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/E-Filing-SubmitFORM.html";
        return path;
    }

    public static String getSampleXmlFile(String itr, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/FORM.xml";
        return FormConfigUtil.getExternalForm(path);
    }

    public static String getValidationFile(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/Validation.xml";
        return FormConfigUtil.getExternalForm(path);
    }

    public static String getValidationFile(String itr, String asstYear, String ver, String validatorName) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/" + validatorName;
        return FormConfigUtil.getExternalForm(path);
    }

    public static InputStream getXpathFile(String itr, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itr + "/" + asstYear + "/" + ver + "/XPath.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static String getImage(String imagePath) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Common/images/" + imagePath;
        return FormConfigUtil.getExternalForm(path);
    }

    public static InputStream getResourceStream_(String path) {
        return FormConfigUtil.class.getResourceAsStream(path);
    }

    public static InputStream getResourceStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getExternalFormHelp(String path) {
        URL url = FormConfigUtil.class.getResource(path);
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public static String getExternalForm(String path) {
        return new File(path).toURI().toString();
    }

    public static String getErrPage() throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/FORMErrorPage.html";
        return FormConfigUtil.getExternalForm(path);
    }

    public static InputStream getApplicationPropertiesPath(String itrName, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/Application.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getCSVImportPath(String itrName, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/CSV_Import.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static String getXsdPath(String itrName, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/FORM.xsd";
        return FormConfigUtil.getExternalForm(path);
    }

    public static InputStream getDeleteZeroNodes(String itrName, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/DeleteZeroNodes.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getXPathToFieldProperties(String itrName, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/XPath_To_Field.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getConfigURL() {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/FORM_CONFIG_URL.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getIFSCURL() {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/IFSC.gz";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getVersionConfigURL() {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/FORM_VERSION_CONFIG.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static InputStream getDeleteNodeGenereteXml(String itrName, String asstYear, String ver) {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/Delete_Nodes_GenerateXML.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static String getCssPath(String css) {
        String path = FormConfigUtil.getActulaJarPath() + "/Common/css/" + css;
        return FormConfigUtil.getExternalForm(path);
    }

    public static File getHtmlTempFile(String itrName, String asstYear, String ver) throws Exception {
        return File.createTempFile("SubmitFORMTemp", ".html");
    }

    public static String getWebservicePage() throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/WebService.html";
        return FormConfigUtil.getExternalForm(path);
    }

    public static String getFormSuccessPage() throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/FormSuccess.html";
        return FormConfigUtil.getExternalForm(path);
    }

    public static String getHelpPage(String itrName, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/" + itrName + "/" + asstYear + "/" + ver + "/Help.html";
        return FormConfigUtil.getExternalForm(path);
    }

    public static MainController getMainController() {
        return mainController;
    }

    public static void setMainController(MainController mainController) {
        FormConfigUtil.mainController = mainController;
    }

    public static InputStream getNameSpaceProperties() {
        String path = FormConfigUtil.getActulaJarPath() + "/Config/NamespaceConfig.properties";
        return FormConfigUtil.getResourceStream(path);
    }

    public static String getPreviewScript(String itrName, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Common/scripts/preview.js";
        InputStream is = FormConfigUtil.getResourceStream(path);
        File jsTempFile = File.createTempFile("preview", ".js");
        byte[] b = new byte[is.available()];
        is.read(b);
        FileOutputStream fos = new FileOutputStream(jsTempFile);
        fos.write(b);
        is.close();
        fos.close();
        return jsTempFile.getName();
    }

    public static String getPreviewCss(String itrName, String asstYear, String ver) throws Exception {
        String path = FormConfigUtil.getActulaJarPath() + "/Common/css/preview.css";
        InputStream is = FormConfigUtil.getResourceStream(path);
        File jsTempFile = File.createTempFile("preview", ".css");
        byte[] b = new byte[is.available()];
        is.read(b);
        FileOutputStream fos = new FileOutputStream(jsTempFile);
        fos.write(b);
        is.close();
        fos.close();
        return jsTempFile.getName();
    }

    static {
        FORM_CONFIG = new LinkedHashMap<String, Form>();
        DD_MM_YYYY_HH_MM_SS = new SimpleDateFormat(inputFormat);
        DELETE_NODE_GENERATE_XML = new ArrayList<String>();
        config_properties = new Properties();
        version_properties = new Properties();
        IMPORT_MULTIPLE_ROOT = new HashMap<String, String>();
        IMPORT_MULTIPLE_VALUES = new HashMap<String, String>();
        EXPORT_MULTIPLE_VALUES = new HashMap<String, String>();
        ALL_FORMS = new LinkedHashMap<String, String>();
        FORMS_INCO_FILED = new HashMap<String, String>();
        FORMS_DSC_REQD = new HashMap<String, String>();
        SAME_TAG_FORMS = new ArrayList<String>();
    }
}

